/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings.dataImport;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import kim.bin.bio.wings.dataImport.DataException;
import kim.bio.Sex;

public class DataCheck
implements Sex {
    private int type;
    public static final int INT = 0;
    public static final int DOUBLE = 1;
    public static final int SEX = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    public static final int BOOLEAN = 5;
    public static final int STRING = 100;

    public DataCheck(int type) {
        this.type = type;
    }

    public Object check(String value) {
        try {
            switch (this.type) {
                case 0: {
                    return DataCheck.checkInt(value);
                }
                case 1: {
                    return DataCheck.checkDouble(value);
                }
                case 2: {
                    return DataCheck.checkSex(value);
                }
                case 3: {
                    return DataCheck.checkDate(value);
                }
                case 4: {
                    return DataCheck.checkTime(value);
                }
                case 5: {
                    return DataCheck.checkBoolean(value);
                }
            }
            return value.getClass().isInstance(String.class);
        }
        catch (DataException ex) {
            return null;
        }
    }

    public static int checkInt(String value) throws DataException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DataException("String value '" + value + "' is not a integer");
        }
    }

    public static double checkDouble(String value) throws DataException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new DataException("String value '" + value + "' is not a double");
        }
    }

    public static boolean checkBoolean(String value) throws DataException {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new DataException("String value '" + value + "' is not a boolean");
        }
    }

    public static int checkSex(String value) throws DataException {
        if ((value = value.trim()).equalsIgnoreCase("F")) {
            return 2;
        }
        if (value.equalsIgnoreCase("Female")) {
            return 2;
        }
        if (value.equalsIgnoreCase("XX")) {
            return 2;
        }
        if (value.equalsIgnoreCase("ZW")) {
            return 2;
        }
        if (value.equalsIgnoreCase("M")) {
            return 1;
        }
        if (value.equalsIgnoreCase("Male")) {
            return 1;
        }
        if (value.equalsIgnoreCase("XY")) {
            return 1;
        }
        if (value.equalsIgnoreCase("ZZ")) {
            return 1;
        }
        if (value.equalsIgnoreCase("PM")) {
            return 3;
        }
        if (value.equalsIgnoreCase("PseudoMale")) {
            return 3;
        }
        if (value.equalsIgnoreCase("PF")) {
            return 4;
        }
        if (value.equalsIgnoreCase("PseudoFemale")) {
            return 4;
        }
        if (value.equalsIgnoreCase("IS")) {
            return 5;
        }
        if (value.equalsIgnoreCase("Intersex")) {
            return 5;
        }
        if (value.equalsIgnoreCase("U")) {
            return -1;
        }
        if (value.equalsIgnoreCase("Unknown")) {
            return -1;
        }
        if (value.equalsIgnoreCase("Unasigned")) {
            return -1;
        }
        throw new DataException("String value '" + value + "' is not a sex indicator");
    }

    public static String checkDate(String value) throws DataException {
        int day = -1;
        int month = -1;
        int year = -1;
        try {
            DateFormat date = DateFormat.getDateInstance();
            date.parse(value);
            return value;
        }
        catch (ParseException ex) {
            StringTokenizer cells;
            block27: {
                String testValue;
                cells = new StringTokenizer(value, "-\\/_. ");
                if (cells.countTokens() == 1) {
                    try {
                        Integer.parseInt(value.substring(0, 1));
                        Integer.parseInt(value.substring(2, 3));
                        Integer.parseInt(value.substring(4));
                        return value;
                    }
                    catch (Exception e) {
                        throw new DataException("(1) Input value '" + value + "' is an invalid date format");
                    }
                }
                try {
                    day = Integer.parseInt(cells.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataException("(2) Input value '" + value + "' is an invalid date format");
                }
                try {
                    testValue = cells.nextToken();
                }
                catch (NoSuchElementException e) {
                    throw new DataException("(3) Input value '" + value + "' is an invalid date format");
                }
                try {
                    month = Integer.parseInt(testValue);
                }
                catch (NumberFormatException nfe) {
                    testValue = testValue.toLowerCase();
                    if (testValue.startsWith("jan")) {
                        month = 1;
                        break block27;
                    }
                    if (testValue.startsWith("feb")) {
                        month = 2;
                        break block27;
                    }
                    if (testValue.startsWith("mar")) {
                        month = 3;
                        break block27;
                    }
                    if (testValue.startsWith("apr")) {
                        month = 4;
                        break block27;
                    }
                    if (testValue.startsWith("may")) {
                        month = 5;
                        break block27;
                    }
                    if (testValue.startsWith("jun")) {
                        month = 6;
                        break block27;
                    }
                    if (testValue.startsWith("jul")) {
                        month = 7;
                        break block27;
                    }
                    if (testValue.startsWith("aug")) {
                        month = 8;
                        break block27;
                    }
                    if (testValue.startsWith("sep")) {
                        month = 9;
                        break block27;
                    }
                    if (testValue.startsWith("oct")) {
                        month = 10;
                        break block27;
                    }
                    if (testValue.startsWith("nov")) {
                        month = 11;
                        break block27;
                    }
                    if (testValue.startsWith("dec")) {
                        month = 12;
                        break block27;
                    }
                    throw new DataException("(4) Input value '" + value + "' is an invalid date format");
                }
            }
            try {
                year = Integer.parseInt(cells.nextToken());
            }
            catch (NumberFormatException | NoSuchElementException numberFormatException) {
                throw new DataException("(5) Input value '" + value + "' is an invalid date format");
            }
            Calendar c = Calendar.getInstance();
            c.setLenient(false);
            try {
                c.set(year, month, day);
                return value;
            }
            catch (Exception e) {
                throw new DataException("(6) Input value '" + value + "' is an invalid date format");
            }
        }
    }

    public static String checkTime(String value) throws DataException {
        return value;
    }
}

