/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import kim.awt.composite.JFileLocationPanel;
import kim.bin.bio.wings.GlobalVariables;
import kim.bin.bio.wings.fileTypes.LandMarkDefinitionFile;
import kim.bin.bio.wings.fileTypes.SpecificFilter;
import kim.util.JGridBag;

public class Preferences
extends JDialog {
    private static final long serialVersionUID = 1L;
    private GridBagLayout gb = new GridBagLayout();
    private JLabel propertiesL = new JLabel("Properties location: ");
    private JLabel LMDefinitionL = new JLabel("LandMark definition file location: ");
    private JFileLocationPanel propertiesSelector;
    private JFileLocationPanel LMDefinitionSelector;
    private JButton ok = new JButton("Save");
    private JButton cancel = new JButton("Cancel");
    private File dir = null;
    private JCheckBox saveOverlays = new JCheckBox("Save overlay images");
    private JLabel fileTypeL = new JLabel("File type");
    private ButtonGroup fileTypes = new ButtonGroup();
    private JRadioButton jpeg = new JRadioButton("*.jpg");
    private JRadioButton tiff = new JRadioButton("*.tiff");
    private JRadioButton png = new JRadioButton("*.png");
    private JLabel fileSizeL = new JLabel("File size");
    private ButtonGroup fileSizes = new ButtonGroup();
    private JRadioButton originalSize = new JRadioButton("Original");
    private JRadioButton smallSize = new JRadioButton("Small (app. 320 x 240)");
    private JLabel parametersL = new JLabel("Default parameters");
    private JLabel openRadiusL = new JLabel("Open radius");
    private JLabel structElementHeightL = new JLabel("Structural element height");
    private JLabel thresholdL = new JLabel("Threshold");
    private JLabel fillSizeL = new JLabel("Fill size");
    private JLabel shortCleanL = new JLabel("Short clean segment length");
    private JLabel longCleanL = new JLabel("Long clean segment length");
    private JSpinner openRadius = new JSpinner();
    private JSpinner structElementHeight = new JSpinner();
    private JSpinner threshold = new JSpinner();
    private JSpinner fillSize = new JSpinner();
    private JSpinner shortClean = new JSpinner();
    private JSpinner longClean = new JSpinner();
    private JPanel top = new JPanel(this.gb);
    private JPanel mid = new JPanel(this.gb);
    private JPanel bottum = new JPanel(this.gb);

    public Preferences(JFrame f) {
        this(f, true);
    }

    public Preferences(JFrame f, boolean filePresent) {
        super(f, "Set file locations of external programs!", true);
        this.dir = new File(System.getProperty("user.dir"));
        this.propertiesSelector = new JFileLocationPanel("properties", this.dir, new SpecificFilter(true, "wings.properties"), 2);
        this.LMDefinitionSelector = new JFileLocationPanel("LandMark definition", this.dir, LandMarkDefinitionFile.getFilter(), 2);
        if (filePresent) {
            this.saveOverlays.setSelected(Boolean.parseBoolean(GlobalVariables.props.getProperty("overlay.store")));
        } else {
            this.saveOverlays.setSelected(true);
        }
        this.troggle(this.saveOverlays.isSelected());
        this.jpeg.setMnemonic(74);
        this.tiff.setMnemonic(84);
        this.png.setMnemonic(80);
        this.originalSize.setMnemonic(79);
        this.smallSize.setMnemonic(83);
        this.fileTypes.add(this.jpeg);
        this.fileTypes.add(this.tiff);
        this.fileTypes.add(this.png);
        this.fileSizes.add(this.originalSize);
        this.fileSizes.add(this.smallSize);
        this.jpeg.setActionCommand("jpeg");
        this.tiff.setActionCommand("tiff");
        this.png.setActionCommand("png");
        this.originalSize.setActionCommand("originalSize");
        this.smallSize.setActionCommand("smallSize");
        if (filePresent) {
            if (GlobalVariables.props.getProperty("overlay.fileType") != null) {
                if (GlobalVariables.props.getProperty("overlay.fileType").equalsIgnoreCase("tiff")) {
                    this.tiff.setSelected(true);
                } else if (GlobalVariables.props.getProperty("overlay.fileType").equalsIgnoreCase("png")) {
                    this.png.setSelected(true);
                } else {
                    this.jpeg.setSelected(true);
                }
            } else {
                this.tiff.setSelected(true);
            }
        }
        if (filePresent) {
            if (GlobalVariables.props.getProperty("overlay.size") != null) {
                if (GlobalVariables.props.getProperty("overlay.size").equalsIgnoreCase("originalSize")) {
                    this.originalSize.setSelected(true);
                } else {
                    this.smallSize.setSelected(true);
                }
            } else {
                this.smallSize.setSelected(true);
            }
        } else {
            this.originalSize.setSelected(true);
        }
        this.openRadius.setValue(GlobalVariables.getInt("parameters.openRadius", 3));
        this.structElementHeight.setValue(GlobalVariables.getInt("parameters.structElementHeight", 15));
        this.threshold.setValue(GlobalVariables.getInt("parameters.threshold", 7));
        this.fillSize.setValue(GlobalVariables.getInt("parameters.fillSize", 80));
        this.shortClean.setValue(GlobalVariables.getInt("parameters.shortClean", 5));
        this.longClean.setValue(GlobalVariables.getInt("parameters.longClean", 8));
        this.getContentPane().setLayout(this.gb);
        JGridBag.add(this.top, (Component)this.propertiesL, 0, 0, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.top, (Component)this.propertiesSelector, 0, 1, 1, 1, 0, 0, 10, 0);
        JGridBag.add(this.top, (Component)this.LMDefinitionL, 0, 2, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.top, (Component)this.LMDefinitionSelector, 0, 3, 1, 1, 0, 0, 0, 0);
        JGridBag.add(this.mid, (Component)this.saveOverlays, 0, 0, 1, 1, 0, 0, 10, 0);
        JGridBag.add(this.mid, (Component)this.fileTypeL, 0, 1, 1, 1, 0, 0, 10, 10);
        JGridBag.add(this.mid, (Component)this.jpeg, 1, 1, 1, 1, 0, 0, 10, 10);
        JGridBag.add(this.mid, (Component)this.tiff, 2, 1, 1, 1, 0, 0, 10, 10);
        JGridBag.add(this.mid, (Component)this.png, 3, 1, 1, 1, 0, 0, 10, 0);
        JGridBag.add(this.mid, (Component)this.fileSizeL, 0, 2, 1, 1, 0, 0, 10, 10);
        JGridBag.add(this.mid, (Component)this.originalSize, 1, 2, 1, 1, 0, 0, 10, 10);
        JGridBag.add(this.mid, (Component)this.smallSize, 2, 2, 2, 1, 0, 0, 10, 0);
        JGridBag.add(this.bottum, (Component)this.parametersL, 0, 0, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.openRadiusL, 0, 1, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.openRadius, 1, 1, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.structElementHeightL, 0, 2, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.structElementHeight, 1, 2, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.thresholdL, 0, 3, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.threshold, 1, 3, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.fillSizeL, 0, 4, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.fillSize, 1, 4, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.shortCleanL, 0, 5, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.shortClean, 1, 5, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this.bottum, (Component)this.longCleanL, 0, 6, 1, 1, 10, 0, 0, 10);
        JGridBag.add(this.bottum, (Component)this.longClean, 1, 6, 1, 1, 10, 0, 0, 0);
        JGridBag.add(this, (Component)this.top, 0, 0, 1, 1, 15, 15, 15, 15);
        JGridBag.add(this, (Component)this.mid, 0, 1, 1, 1, 0, 15, 15, 15);
        JGridBag.add(this, (Component)this.bottum, 1, 0, 1, 2, 15, 0, 15, 15);
        JGridBag.add(this, (Component)this.ok, 0, 10, 1, 1, 0, 15, 15, 0);
        JGridBag.add(this, (Component)this.cancel, 1, 10, 1, 1, 0, 0, 15, 15);
        this.propertiesSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("properties".equals(e.getPropertyName())) {
                    try {
                        Properties props = new Properties();
                        props.load(new BufferedInputStream(new FileInputStream(new File(System.getProperty("user.dir"), "wings.properties"))));
                        Preferences.this.propertiesSelector.setText(props.getProperty("properties.dir", ""), "wings.properties");
                        Preferences.this.LMDefinitionSelector.setText(props.getProperty("landmark.definition", ""), "*.definition");
                    }
                    catch (FileNotFoundException fnfe) {
                        Preferences.this.propertiesSelector.setText(Preferences.this.dir + File.separator + "wings.properties");
                    }
                    catch (IOException ioe) {
                        Preferences.this.propertiesSelector.setText(Preferences.this.dir + File.separator + "wings.properties");
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Preferences.this.setProperties()) {
                    Preferences.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(Preferences.this, "Missing essential file locations, wings will exit");
                    System.exit(0);
                }
            }
        });
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Preferences.this.setProperties()) {
                    Preferences.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(Preferences.this, "Missing essential file locations, wings will exit");
                    System.exit(0);
                }
            }
        });
        this.ok.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Preferences.this.setProperties()) {
                    Preferences.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(Preferences.this, "Missing essential data, wings will exit");
                    System.exit(0);
                }
            }
        });
        this.saveOverlays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.troggle(Preferences.this.saveOverlays.isSelected());
            }
        });
        this.pack();
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    private void setFileProperty(Properties props, String key, String value) throws FileNotFoundException {
        if (!new File(value).exists()) {
            throw new FileNotFoundException("Did not find: " + value);
        }
        props.setProperty(key, value);
        System.setProperty(key, value);
    }

    private void setProperty(Properties props, String key, String value) {
        props.setProperty(key, value);
        System.setProperty(key, value);
    }

    private boolean setProperties() {
        Properties props = new Properties();
        try {
            props.setProperty("properties.dir", this.dir + File.separator + "wings.properties");
            this.setProperty(props, "overlay.store", "" + this.saveOverlays.isSelected());
            this.setProperty(props, "overlay.size", this.fileSizes.getSelection().getActionCommand());
            this.setProperty(props, "overlay.fileType", this.fileTypes.getSelection().getActionCommand());
            this.setFileProperty(props, "landmark.definition", this.LMDefinitionSelector.getText(true));
            this.setProperty(props, "properties.dir", this.dir + File.separator + "wings.properties");
            this.setProperty(props, "parameters.openRadius", "" + this.openRadius.getValue());
            this.setProperty(props, "parameters.structElementHeight", "" + this.structElementHeight.getValue());
            this.setProperty(props, "parameters.threshold", "" + this.threshold.getValue());
            this.setProperty(props, "parameters.fillSize", "" + this.fillSize.getValue());
            this.setProperty(props, "parameters.shortClean", "" + this.shortClean.getValue());
            this.setProperty(props, "parameters.longClean", "" + this.longClean.getValue());
            props.store(new FileOutputStream(new File(this.dir, "wings.properties")), "Properties for wings");
            return true;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Preferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public void troggle(boolean status) {
        this.jpeg.setEnabled(status);
        this.tiff.setEnabled(status);
        this.png.setEnabled(status);
        this.originalSize.setEnabled(status);
        this.smallSize.setEnabled(status);
        this.fileTypeL.setEnabled(status);
        this.fileSizeL.setEnabled(status);
    }
}

