/*
 * Decompiled with CFR 0.152.
 */
package kim.bin.bio.wings;

import commonSense.DifferentArrayLengthException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.PointXD;
import kim.bin.bio.wings.util.Side;

public class PointMatrix
extends Matrix
implements Side {
    private static final long serialVersionUID = 1L;
    boolean pointsSet = false;
    public double[] distortions = null;
    public double[] corrections = null;
    protected int orientation = 0;

    public PointMatrix(double[] distortions) {
        this.setCorrections(distortions);
        this.pointsSet = false;
    }

    public PointMatrix(int noPoints, double[] distortions) {
        super(noPoints, distortions.length);
        this.setCorrections(distortions);
        this.pointsSet = false;
    }

    public PointMatrix(double[][] d, double[] distortions) {
        super(d);
        this.setCorrections(distortions);
        this.pointsSet = false;
    }

    public PointMatrix(PointXD[] points, double[] distortions) {
        super(points.length, 2);
        this.setCorrections(distortions);
        for (int x = 0; x < this.rows; ++x) {
            this.data[x][0] = points[x].getX();
            this.data[x][1] = points[x].getY();
        }
        this.pointsSet = true;
    }

    public PointMatrix(double[] x, double[] y, double[] distortions) {
        super(x.length, 2);
        this.setCorrections(distortions);
        if (x.length != y.length) {
            throw new DifferentArrayLengthException("X (" + x + ") and Y (" + y + ") are of different length");
        }
        for (int i = 0; i < this.rows; ++i) {
            this.data[i][0] = x[i];
            this.data[i][1] = y[i];
        }
        this.pointsSet = true;
    }

    public void setCorrections(double[] dis) {
        this.distortions = new double[this.columns];
        this.corrections = new double[this.columns];
        this.corrections[0] = 0.0;
        this.corrections[1] = 0.0;
        this.distortions[0] = dis[0];
        this.distortions[1] = dis[1];
        for (int x = 2; x < this.columns; ++x) {
            this.distortions[x] = dis[x];
            this.corrections[x] = 0.0;
        }
    }

    public boolean setNoPoints(int noPoints, int dim) {
        if (this != null) {
            this.data = new double[noPoints][dim];
            this.rows = noPoints;
            this.columns = dim;
            return true;
        }
        return false;
    }

    public int getNoPoints() {
        return this.rows;
    }

    public double[] getDistortions() {
        return this.distortions;
    }

    public double[] getPoint(int number) throws ArrayIndexOutOfBoundsException {
        return this.getRow(number);
    }

    public String getDataString(String delimiter, boolean multiple, boolean includePointCount) {
        return this.getDataString(delimiter, multiple, includePointCount, 1.0);
    }

    public String getDataString(String delimiter, boolean multiple, boolean includePointCount, double scale) {
        String lineEnd = multiple ? "\r\n" : delimiter;
        String temp = includePointCount ? "" + this.rows + lineEnd : "";
        for (int x = 0; x < this.rows - 1; ++x) {
            for (int y = 0; y < this.columns - 1; ++y) {
                temp = temp + this.data[x][y] * scale + delimiter;
            }
            temp = temp + this.data[x][this.columns - 1] * scale + lineEnd;
        }
        for (int y = 0; y < this.columns - 1; ++y) {
            temp = temp + this.data[this.rows - 1][y] * scale + delimiter;
        }
        temp = temp + this.data[this.rows - 1][this.columns - 1] * scale;
        return temp;
    }

    public Matrix getCorrectedDataMatrix(boolean distortionCorrection, boolean rotationCorrection) {
        double[][] newData = new double[this.rows][this.columns];
        double[] dis = new double[this.columns];
        double[] cors = new double[this.columns];
        for (int a = 0; a < this.columns; ++a) {
            dis[a] = distortionCorrection ? this.distortions[a] : 1.0;
            cors[a] = rotationCorrection ? (double)this.orientation * this.corrections[a] : 0.0;
        }
        for (int x = 0; x < this.rows; ++x) {
            for (int y = 0; y < this.columns; ++y) {
                newData[x][y] = Math.abs(cors[y] - this.data[x][y] * dis[y]);
            }
        }
        return new Matrix(newData);
    }
}

