/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.univariate;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Geometrics;
import commonSense.stats.StatUtils;
import commonSense.stats.descriptive.rank.Median;
import commonSense.stats.distribution.FDistribution;

public class Levene {
    double sig;

    public Levene(Matrix[] m2) {
        this(m2, null);
    }

    public Levene(Matrix[] m2, int[] included) {
        Matrix m1 = Geometrics.estimateMean(m2);
        int variables = m1.getRowDimension();
        int ni = m2.length;
        double[][] dis = new double[variables][ni];
        Matrix md = null;
        Matrix SSCP = null;
        for (int x = 0; x < ni; ++x) {
            md = m1.subtract(m2[x]);
            SSCP = md.multiply(md.transpose());
            for (int y = 0; y < variables; ++y) {
                dis[y][x] = SSCP.getEntry(y, y);
            }
        }
        double[] medians = new double[variables];
        for (int x = 0; x < variables; ++x) {
            medians[x] = new Median().evaluate(dis[x]);
        }
        double[][] diffs = new double[variables][ni];
        for (int x = 0; x < ni; ++x) {
            for (int y = 0; y < variables; ++y) {
                diffs[y][x] = Math.abs(medians[y] - dis[y][x]);
            }
        }
        if (included != null) {
            diffs = new Matrix(diffs).getSubMatrix(included, 0, ni - 1).getData();
        }
        double mean = 0.0;
        for (int x = 0; x < ni; ++x) {
            for (int y = 0; y < variables; ++y) {
                mean += diffs[y][x];
            }
        }
        mean /= (double)(ni * variables);
        double[] means = new double[variables];
        for (int x = 0; x < variables; ++x) {
            means[x] = StatUtils.mean(diffs[x]);
        }
        double SST = 0.0;
        double SSM = 0.0;
        double SSE = 0.0;
        for (int x = 0; x < variables; ++x) {
            SSM += (double)ni * Math.pow(means[x] - mean, 2.0);
            for (int y = 0; y < ni; ++y) {
                SSE += Math.pow(diffs[x][y] - means[x], 2.0);
            }
        }
        SST = SSM + SSE;
        double MSM = SSM / (double)(variables - 1);
        double MSE = SSE / (double)((ni - 1) * variables);
        double F = MSM / MSE;
        FDistribution fdis = new FDistribution(variables - 1, (ni - 1) * variables);
        try {
            this.sig = 1.0 - fdis.cumulativeProbability(F);
        }
        catch (Exception e) {
            this.sig = -1.0;
        }
    }

    public double getSignificance() {
        return this.sig;
    }

    public static void main(String[] args) {
        Matrix[] m = new Matrix[3];
        double[][] data4 = new double[][]{{1.0, 1.0}, {1.0, 3.0}, {2.0, 4.0}, {3.0, 1.0}};
        double[][] data5 = new double[][]{{1.0, 1.0}, {1.0, 3.5}, {2.0, 3.8}, {3.0, 1.2}};
        double[][] data6 = new double[][]{{1.0, 1.0}, {1.0, 2.9}, {2.0, 4.1}, {3.0, 0.75}};
        m[0] = new Matrix(data4);
        m[1] = new Matrix(data5);
        m[2] = new Matrix(data6);
        Levene levene = new Levene(m, null);
        System.out.println("p = " + levene.getSignificance());
    }
}

