/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.regression;

import commonSense.math.MathException;
import commonSense.stats.distribution.DistributionFactory;
import commonSense.stats.distribution.FDistribution;
import commonSense.stats.regression.LinearRegression;
import java.io.Serializable;

public class MajorAxisRegression
extends LinearRegression
implements Serializable {
    static final long serialVersionUID = -3004689053607543335L;

    @Override
    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (StrictMath.abs(this.SSxx) < 4.9E-323) {
            return Double.NaN;
        }
        double[] eigen = this.getEigenvalues();
        return this.SSxy / (double)(this.n - 1L) / (eigen[0] - this.SSyy / (double)(this.n - 1L));
    }

    @Override
    public double[] getSlopeConfidenceInterval(double alpha) throws MathException {
        double f = this.getFDistribution().inverseCumulativeProbability(1.0 - alpha / 2.0);
        double[] eigen = this.getEigenvalues();
        double H = f / ((eigen[0] / eigen[1] + eigen[1] / eigen[0] - 2.0) * (double)this.df);
        double A = StrictMath.sqrt(H / (1.0 - H));
        double[] CI = new double[2];
        double slope = this.getSlope();
        CI[0] = (slope - A) / (1.0 + slope * A);
        CI[1] = (slope + A) / (1.0 - slope * A);
        return CI;
    }

    public double[] getEigenvalues() {
        double[] eigen = new double[2];
        double varX = this.SSxx / (double)(this.n - 1L);
        double varY = this.SSyy / (double)(this.n - 1L);
        double covar = this.SSxy / (double)(this.n - 1L);
        double D = StrictMath.sqrt((varX + varY) * (varX + varY) - 4.0 * (varX * varY - covar * covar));
        eigen[0] = (varX + varY + D) / 2.0;
        eigen[1] = (varX + varY - D) / 2.0;
        return eigen;
    }

    protected FDistribution getFDistribution() {
        return DistributionFactory.newInstance().createFDistribution(1.0, this.df);
    }

    @Override
    public double getSumOfSquaresTotal() {
        return this.SSxx + this.SSyy;
    }

    @Override
    public double getSumOfSquaresModel(double slope) {
        return (this.SSxx + 2.0 * slope * this.SSxy + slope * slope * this.SSyy) / (slope * slope + 1.0);
    }

    @Override
    public double[] predict(double x, double y) {
        double[] point = new double[2];
        double b = this.getSlope();
        double a = this.getIntercept(b);
        point[0] = (y + x / b - a) / (b + 1.0 / b);
        point[1] = a + point[0] * b;
        return point;
    }

    @Override
    public double[] getYConfidenceInterval(double y, double alpha) throws MathException {
        double[] CI = new double[]{0.0, 0.0};
        return CI;
    }
}

