/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.regression;

import commonSense.math.MathException;
import commonSense.stats.regression.LinearRegression;
import java.io.Serializable;

public class LeastSquaresRegression
extends LinearRegression
implements Serializable {
    static final long serialVersionUID = -3004689053607543335L;

    @Override
    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (StrictMath.abs(this.SSxx) < 4.9E-323) {
            return Double.NaN;
        }
        return this.SSxy / this.SSxx;
    }

    @Override
    public double[] getSlopeConfidenceInterval(double alpha) throws MathException {
        if (alpha >= 1.0 || alpha <= 0.0) {
            throw new IllegalArgumentException();
        }
        double[] CI = new double[2];
        double b = this.getSlope();
        double t = this.getSlopeStdErr() * this.getTDistribution().inverseCumulativeProbability(1.0 - alpha / 2.0);
        CI[0] = b - t;
        CI[1] = b + t;
        return CI;
    }

    public double predict(double x) {
        double b1 = this.getSlope();
        return this.getIntercept(b1) + b1 * x;
    }

    @Override
    public double[] predict(double x, double y) {
        double[] point = new double[]{x, this.predict(x)};
        return point;
    }

    @Override
    public double[] getYConfidenceInterval(double y, double alpha) throws MathException {
        if (alpha >= 1.0 || alpha <= 0.0) {
            throw new IllegalArgumentException();
        }
        double[] CI = new double[2];
        if (!Double.isNaN(this.Y)) {
            CI[1] = 0.0;
            CI[0] = 0.0;
            return CI;
        }
        double slope = this.getSlope();
        double t = this.getYStdErr((y - this.getIntercept(slope)) / slope) * this.getTDistribution().inverseCumulativeProbability(1.0 - alpha / 2.0);
        CI[0] = y - t;
        CI[1] = y + t;
        return CI;
    }

    @Override
    public double getSumOfSquaresTotal() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.SSyy;
    }

    @Override
    public double getSumOfSquaresModel(double slope) {
        return slope * this.SSxy;
    }
}

