/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.random;

import commonSense.math.linear.CholeskyDecomposition;
import commonSense.math.linear.Matrix;
import edu.cornell.lassp.houle.RngPack.RanMT;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;

public class MultivariateNormalPseudoRandom {
    private CholeskyDecomposition cd;
    private RandomElement random = new RanMT(RandomSeedable.ClockSeed());
    int columns = 0;

    public MultivariateNormalPseudoRandom(Matrix covar) {
        this.columns = covar.getColumnDimension();
        this.cd = new CholeskyDecomposition(covar);
    }

    public Matrix getData(int dataPoints) {
        return this.getData(dataPoints, 1.0);
    }

    public Matrix getData(int dataPoints, double sd) {
        double[][] data = new double[dataPoints][this.columns];
        for (int x = 0; x < dataPoints; ++x) {
            for (int y = 0; y < this.columns; ++y) {
                data[x][y] = this.random.gaussian(sd);
            }
        }
        return new Matrix(data).multiply(this.cd.getL().transpose());
    }

    public static void main(String[] a) {
    }
}

