/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.multivariate;

import commonSense.math.linear.Matrix;

public class GLM {
    public static double getLambda(Matrix data, double[] sizes) {
        Matrix design = new Matrix(sizes.length, 2);
        for (int x = 0; x < sizes.length; ++x) {
            design.setEntry(x, 0, 1.0);
            design.setEntry(x, 1, sizes[x]);
        }
        Matrix beta = design.transpose().multiply(design).inverse().multiply(design.transpose().multiply(data));
        Matrix predicted = design.multiply(beta);
        GLM.print(data.transpose().multiply(data));
        Matrix error = predicted.subtract(data);
        double[] means = data.columnMeans();
        Matrix dataMeans = new Matrix(sizes.length, means.length);
        for (int x = 0; x < sizes.length; ++x) {
            for (int y = 0; y < means.length; ++y) {
                dataMeans.setEntry(x, y, means[y]);
            }
        }
        Matrix totalDeviation = data.subtract(dataMeans);
        Matrix errorSSCP = error.transpose().multiply(error);
        Matrix residualY = data.subtract(dataMeans);
        Matrix totalSSCP = residualY.transpose().multiply(residualY);
        return errorSSCP.getDeterminant() / totalSSCP.getDeterminant();
    }

    private static void print(String[] a) {
        for (int x = 0; x < a.length; ++x) {
            System.out.print(a[x] + " ");
        }
        System.out.println("");
    }

    private static void print(double[] a) {
        for (int x = 0; x < a.length; ++x) {
            System.out.print(a[x] + " ");
        }
        System.out.println("");
    }

    private static void print(Matrix[] a) {
        for (int x = 0; x < a.length; ++x) {
            GLM.print(a[x].getData());
        }
    }

    private static void print(Matrix a) {
        GLM.print(a.getData());
    }

    private static void print(String a) {
        System.out.println(a);
    }

    private static void print(double[][] a) {
        System.out.println("Start Matrix");
        for (int x = 0; x < a.length; ++x) {
            for (int y = 0; y < a[0].length; ++y) {
                System.out.print(a[x][y] + " ");
            }
            System.out.println("");
        }
        System.out.println("End Matrix");
    }
}

