/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Gamma;
import commonSense.math.util.MathUtils;
import commonSense.stats.distribution.AbstractIntegerDistribution;
import commonSense.stats.distribution.DistributionFactory;
import commonSense.stats.distribution.IntegerDistribution;
import commonSense.stats.distribution.NormalDistribution;
import java.io.Serializable;

public class PoissonDistribution
extends AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    static final long serialVersionUID = -3349935121172596109L;
    private double mean;

    public PoissonDistribution(double p) {
        this.setMean(p);
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("The Poisson mean must be positive");
        }
        this.mean = p;
    }

    @Override
    public double probability(int x) {
        if (x < 0 || x == Integer.MAX_VALUE) {
            return 0.0;
        }
        return Math.pow(this.getMean(), x) / MathUtils.factorialDouble(x) * Math.exp(-this.mean);
    }

    @Override
    public double cumulativeProbability(int x) throws MathException {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, this.mean, 1.0E-12, Integer.MAX_VALUE);
    }

    public double normalApproximateProbability(int x) throws MathException {
        NormalDistribution normal = DistributionFactory.newInstance().createNormalDistribution(this.getMean(), Math.sqrt(this.getMean()));
        return normal.cumulativeProbability((double)x + 0.5);
    }

    @Override
    protected int getDomainLowerBound(double p) {
        return 0;
    }

    @Override
    protected int getDomainUpperBound(double p) {
        return Integer.MAX_VALUE;
    }
}

