/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.math.special.Gamma;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public class GammaDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -3239549463135430361L;
    private double alpha;
    private double beta;

    public GammaDistribution(double alpha, double beta) {
        this.setAlpha(alpha);
        this.setBeta(beta);
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.getAlpha(), x / this.getBeta());
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    public void setAlpha(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha must be positive");
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setBeta(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta must be positive");
        }
        this.beta = beta;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    protected double getDomainLowerBound(double p) {
        return Double.MIN_VALUE;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getAlpha() * this.getBeta() : Double.MAX_VALUE;
        return ret;
    }

    @Override
    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getAlpha() * this.getBeta() * 0.5 : this.getAlpha() * this.getBeta();
        return ret;
    }
}

