/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.distribution;

import commonSense.math.MathException;
import commonSense.stats.distribution.AbstractContinuousDistribution;
import commonSense.stats.distribution.ContinuousDistribution;
import java.io.Serializable;

public class ExponentialDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = 2401296428283614780L;
    private double mean;

    public ExponentialDistribution(double mean) {
        this.setMean(mean);
    }

    public void setMean(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("mean must be positive.");
        }
        this.mean = mean;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-x / this.getMean());
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathException {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability argument must be between 0 and 1 (inclusive)");
        }
        double ret = p == 1.0 ? Double.POSITIVE_INFINITY : -this.getMean() * Math.log(1.0 - p);
        return ret;
    }

    @Override
    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        if (p < 0.5) {
            return this.getMean();
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double p) {
        if (p < 0.5) {
            return this.getMean() * 0.5;
        }
        return this.getMean();
    }
}

