/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.matrix;

import commonSense.math.linear.Matrix;
import commonSense.stats.descriptive.matrix.AbstractMatrixStatistic;
import commonSense.stats.descriptive.matrix.SpecialMatrices;

public class CovarianceMatrix
extends AbstractMatrixStatistic {
    private Matrix covar;

    public CovarianceMatrix(Matrix values, boolean type) {
        this.covar = this.evaluate(values, type);
    }

    public CovarianceMatrix(Matrix a) {
        this(a, true);
    }

    public CovarianceMatrix() {
    }

    public Matrix evaluate(Matrix values, boolean type) {
        if (this.test(values)) {
            int noRows = values.getRowDimension();
            Matrix dif = SpecialMatrices.differenceByColumnMeans(values);
            if (type) {
                return dif.transpose().multiply(dif).scalarMultiply(1.0 / ((double)noRows - 1.0));
            }
            return dif.transpose().multiply(dif).scalarMultiply(1.0 / (double)noRows);
        }
        return null;
    }

    @Override
    public Matrix evaluate(Matrix a) {
        return this.evaluate(a, true);
    }

    public Matrix getCovarianceMatrix() {
        return this.covar;
    }
}

