/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive.matrix;

import commonSense.math.linear.Matrix;
import commonSense.stats.descriptive.matrix.AbstractMatrixStatistic;
import commonSense.stats.descriptive.matrix.CovarianceMatrix;

public class CorrelationMatrix
extends AbstractMatrixStatistic {
    private Matrix correl;

    public CorrelationMatrix() {
    }

    public CorrelationMatrix(Matrix values) {
        this.correl = this.evaluate(values, false);
    }

    public CorrelationMatrix(Matrix values, boolean covariance) {
        this.correl = this.evaluate(values, covariance);
    }

    @Override
    public Matrix evaluate(Matrix values) {
        return this.evaluate(values, false);
    }

    public Matrix evaluate(Matrix values, boolean covariance) {
        if (this.test(values)) {
            double[][] covar = covariance ? values.getData() : new CovarianceMatrix().evaluate(values, false).getData();
            int cols = covar[0].length;
            Matrix correl = new Matrix(cols, cols);
            double[][] correlArray = correl.getDataRef();
            for (int col = 0; col < cols; ++col) {
                for (int row = 0; row < cols; ++row) {
                    correlArray[col][row] = covar[col][row] / StrictMath.sqrt(covar[col][col] * covar[row][row]);
                }
            }
            return correl;
        }
        return null;
    }

    public Matrix getCorrelationMatrix() {
        return this.correl;
    }
}

