/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive;

import commonSense.stats.descriptive.SummaryStatistics;
import commonSense.stats.descriptive.moment.GeometricMean;
import commonSense.stats.descriptive.moment.Mean;
import commonSense.stats.descriptive.moment.SecondMoment;
import commonSense.stats.descriptive.moment.Variance;
import commonSense.stats.descriptive.rank.Max;
import commonSense.stats.descriptive.rank.Min;
import commonSense.stats.descriptive.summary.Sum;
import commonSense.stats.descriptive.summary.SumOfLogs;
import commonSense.stats.descriptive.summary.SumOfSquares;
import java.io.Serializable;

public class SummaryStatisticsImpl
extends SummaryStatistics
implements Serializable {
    static final long serialVersionUID = 8787174276883311692L;
    protected long n = 0L;
    protected SecondMoment secondMoment = null;
    protected Sum sum = new Sum();
    protected SumOfSquares sumsq = new SumOfSquares();
    protected Min min = new Min();
    protected Max max = new Max();
    protected SumOfLogs sumLog = new SumOfLogs();
    protected GeometricMean geoMean = new GeometricMean();
    protected Mean mean = null;
    protected Variance variance = null;

    public SummaryStatisticsImpl() {
        this.secondMoment = new SecondMoment();
    }

    @Override
    public void addValue(double value) {
        this.sum.increment(value);
        this.sumsq.increment(value);
        this.min.increment(value);
        this.max.increment(value);
        this.sumLog.increment(value);
        this.geoMean.increment(value);
        this.secondMoment.increment(value);
        ++this.n;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double getSum() {
        return this.sum.getResult();
    }

    @Override
    public double getSumsq() {
        return this.sumsq.getResult();
    }

    @Override
    public double getMean() {
        return new Mean(this.secondMoment).getResult();
    }

    @Override
    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    @Override
    public double getVariance() {
        return new Variance(this.secondMoment).getResult();
    }

    @Override
    public double getMax() {
        return this.max.getResult();
    }

    @Override
    public double getMin() {
        return this.min.getResult();
    }

    @Override
    public double getGeometricMean() {
        return this.geoMean.getResult();
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("SummaryStatistics:\n");
        outBuffer.append("n: " + this.getN() + "\n");
        outBuffer.append("min: " + this.getMin() + "\n");
        outBuffer.append("max: " + this.getMax() + "\n");
        outBuffer.append("mean: " + this.getMean() + "\n");
        outBuffer.append("geometric mean: " + this.getGeometricMean() + "\n");
        outBuffer.append("variance: " + this.getVariance() + "\n");
        outBuffer.append("sum of squares: " + this.getSumsq() + "\n");
        outBuffer.append("standard deviation: " + this.getStandardDeviation() + "\n");
        return outBuffer.toString();
    }

    @Override
    public void clear() {
        this.n = 0L;
        this.min.clear();
        this.max.clear();
        this.sum.clear();
        this.sumLog.clear();
        this.sumsq.clear();
        this.geoMean.clear();
        this.secondMoment.clear();
    }
}

