/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive;

import commonSense.math.util.MathUtils;
import commonSense.stats.descriptive.StatisticalSummary;
import commonSense.stats.descriptive.StatisticalSummaryValues;
import commonSense.stats.descriptive.SummaryStatisticsImpl;
import java.io.Serializable;
import org.apache.commons.discovery.tools.DiscoverClass;

public abstract class SummaryStatistics
implements StatisticalSummary,
Serializable {
    static final long serialVersionUID = -6400596334135654825L;

    public static SummaryStatistics newInstance(Class cls) throws InstantiationException, IllegalAccessException {
        return (SummaryStatistics)cls.newInstance();
    }

    public static SummaryStatistics newInstance() {
        SummaryStatistics instance = null;
        try {
            DiscoverClass dc = new DiscoverClass();
            instance = (SummaryStatistics)dc.newInstance(SummaryStatistics.class, "commonSense.stat.descriptive.SummaryStatisticsImpl");
        }
        catch (Throwable t) {
            return new SummaryStatisticsImpl();
        }
        return instance;
    }

    public StatisticalSummary getSummary() {
        return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
    }

    public abstract void addValue(double var1);

    @Override
    public abstract double getMean();

    public abstract double getGeometricMean();

    @Override
    public abstract double getVariance();

    @Override
    public abstract double getStandardDeviation();

    @Override
    public abstract double getMax();

    @Override
    public abstract double getMin();

    @Override
    public abstract long getN();

    @Override
    public abstract double getSum();

    public abstract double getSumsq();

    public abstract void clear();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics stat = (SummaryStatistics)object;
        return MathUtils.equals(stat.getGeometricMean(), this.getGeometricMean()) && MathUtils.equals(stat.getMax(), this.getMax()) && MathUtils.equals(stat.getMean(), this.getMean()) && MathUtils.equals(stat.getMin(), this.getMin()) && MathUtils.equals(stat.getN(), this.getN()) && MathUtils.equals(stat.getSum(), this.getSum()) && MathUtils.equals(stat.getSumsq(), this.getSumsq()) && MathUtils.equals(stat.getVariance(), this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash(this.getGeometricMean());
        result = result * 31 + MathUtils.hash(this.getGeometricMean());
        result = result * 31 + MathUtils.hash(this.getMax());
        result = result * 31 + MathUtils.hash(this.getMean());
        result = result * 31 + MathUtils.hash(this.getMin());
        result = result * 31 + MathUtils.hash(this.getN());
        result = result * 31 + MathUtils.hash(this.getSum());
        result = result * 31 + MathUtils.hash(this.getSumsq());
        result = result * 31 + MathUtils.hash(this.getVariance());
        return result;
    }
}

