/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive;

import commonSense.stats.descriptive.DescriptiveStatisticsImpl;
import commonSense.stats.descriptive.StatisticalSummary;
import commonSense.stats.descriptive.UnivariateStatistic;
import commonSense.stats.descriptive.moment.GeometricMean;
import commonSense.stats.descriptive.moment.Kurtosis;
import commonSense.stats.descriptive.moment.Mean;
import commonSense.stats.descriptive.moment.Skewness;
import commonSense.stats.descriptive.moment.Variance;
import commonSense.stats.descriptive.rank.Max;
import commonSense.stats.descriptive.rank.Median;
import commonSense.stats.descriptive.rank.Min;
import commonSense.stats.descriptive.rank.Percentile;
import commonSense.stats.descriptive.summary.Sum;
import commonSense.stats.descriptive.summary.SumOfSquares;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.discovery.tools.DiscoverClass;

public abstract class DescriptiveStatistics
implements StatisticalSummary,
Serializable {
    static final long serialVersionUID = 5188298269533339922L;
    public static final int INFINITE_WINDOW = -1;

    public static DescriptiveStatistics newInstance(Class cls) throws InstantiationException, IllegalAccessException {
        return (DescriptiveStatistics)cls.newInstance();
    }

    public static DescriptiveStatistics newInstance() {
        DescriptiveStatistics factory = null;
        try {
            DiscoverClass dc = new DiscoverClass();
            factory = (DescriptiveStatistics)dc.newInstance(DescriptiveStatistics.class, "commonSense.stat.descriptive.DescriptiveStatisticsImpl");
        }
        catch (Throwable t) {
            return new DescriptiveStatisticsImpl();
        }
        return factory;
    }

    public abstract void addValue(double var1);

    @Override
    public double getMean() {
        return this.apply(new Mean());
    }

    public double getMedian() {
        return this.apply(new Median());
    }

    public double getGeometricMean() {
        return this.apply(new GeometricMean());
    }

    @Override
    public double getVariance() {
        return this.apply(new Variance());
    }

    @Override
    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getSkewness() {
        return this.apply(new Skewness());
    }

    public double getKurtosis() {
        return this.apply(new Kurtosis());
    }

    @Override
    public double getMax() {
        return this.apply(new Max());
    }

    @Override
    public double getMin() {
        return this.apply(new Min());
    }

    @Override
    public abstract long getN();

    @Override
    public double getSum() {
        return this.apply(new Sum());
    }

    public double getSumsq() {
        return this.apply(new SumOfSquares());
    }

    public abstract void clear();

    public abstract int getWindowSize();

    public abstract void setWindowSize(int var1);

    public abstract double[] getValues();

    public double[] getSortedValues() {
        double[] sort = this.getValues();
        Arrays.sort(sort);
        return sort;
    }

    public abstract double getElement(int var1);

    public double getPercentile(double p) {
        return this.apply(new Percentile(p));
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("DescriptiveStatistics:\n");
        outBuffer.append("n: " + this.getN() + "\n");
        outBuffer.append("min: " + this.getMin() + "\n");
        outBuffer.append("max: " + this.getMax() + "\n");
        outBuffer.append("mean: " + this.getMean() + "\n");
        outBuffer.append("std dev: " + this.getStandardDeviation() + "\n");
        outBuffer.append("median: " + this.getPercentile(50.0) + "\n");
        outBuffer.append("skewness: " + this.getSkewness() + "\n");
        outBuffer.append("kurtosis: " + this.getKurtosis() + "\n");
        return outBuffer.toString();
    }

    public abstract double apply(UnivariateStatistic var1);
}

