/*
 * Decompiled with CFR 0.152.
 */
package commonSense.stats.descriptive;

import commonSense.math.util.MathUtils;
import commonSense.stats.descriptive.AbstractBivariateStatistic;
import commonSense.stats.descriptive.StorelessBivariateStatistic;
import java.io.Serializable;

public abstract class AbstractStorelessBivariateStatistic
extends AbstractBivariateStatistic
implements StorelessBivariateStatistic,
Serializable {
    static final long serialVersionUID = -44915725420072521L;

    @Override
    public double evaluate(double[][] values) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public double evaluate(double[][] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            this.clear();
            this.incrementAll(values, begin, length);
        }
        return this.getResult();
    }

    @Override
    public double evaluate(double[] xValues, double[] yValues, int begin, int length) {
        if (this.test(xValues, yValues, begin, length)) {
            this.clear();
            this.incrementAll(xValues, yValues, begin, length);
        }
        return this.getResult();
    }

    @Override
    public abstract void clear();

    @Override
    public abstract double getResult();

    @Override
    public void increment(double[] d) {
        this.increment(d[0], d[1]);
    }

    @Override
    public abstract void increment(double var1, double var3);

    @Override
    public void incrementAll(double[][] values) {
        if (values == null) {
            throw new IllegalArgumentException("input values array is null");
        }
        this.incrementAll(values, 0, values.length);
    }

    @Override
    public void incrementAll(double[] xValues, double[] yValues) {
        if (xValues == null) {
            throw new IllegalArgumentException("x-values array is null");
        }
        if (yValues == null) {
            throw new IllegalArgumentException("y-values array is null");
        }
        this.incrementAll(xValues, yValues, 0, xValues.length);
    }

    @Override
    public void incrementAll(double[][] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(values[i][0], values[i][1]);
            }
        }
    }

    @Override
    public void incrementAll(double[] xValues, double[] yValues, int begin, int length) {
        if (this.test(xValues, yValues, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(xValues[i], yValues[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessBivariateStatistic)) {
            return false;
        }
        AbstractStorelessBivariateStatistic stat = (AbstractStorelessBivariateStatistic)object;
        return MathUtils.equals(stat.getResult(), this.getResult()) && MathUtils.equals(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

