/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.CholeskyDecomposition;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.DoubleGeneralizedProcrustes;

public class WeightedGeneralizedProcrustes
extends DoubleGeneralizedProcrustes {
    protected WeightedGeneralizedProcrustes() {
    }

    public WeightedGeneralizedProcrustes(Matrix[] cases) {
        this(cases, 0.001, false);
    }

    public WeightedGeneralizedProcrustes(Matrix[] cases, boolean maxVarianceRotation) {
        this(cases, 0.001, maxVarianceRotation);
    }

    public WeightedGeneralizedProcrustes(Matrix[] cases, double tolerance) {
        this(cases, tolerance, false);
    }

    public WeightedGeneralizedProcrustes(Matrix[] cases, double tolerance, boolean maxVarianceRotation) {
        super(cases, cases, tolerance, maxVarianceRotation);
        this.tolerance = tolerance;
        double newWeightedResidualSS = 0.0;
        double oldWeightedResidualSS = this.newResidualSS;
        int iteration = 0;
        System.out.println("(WGPA) Residual SS(" + iteration + "): " + this.newResidualSS);
        do {
            oldWeightedResidualSS = this.newResidualSS;
            CholeskyDecomposition cd = new CholeskyDecomposition(this.estimateLMCovarMatrix(this.shapeA, true));
            Matrix inv = cd.getL().pseudoInverse();
            this.shapeA = this.weighMatrices(this.shape, inv);
            this.iteration();
            newWeightedResidualSS = this.newResidualSS;
            System.out.println("(WGPA) Residual SS(" + ++iteration + "): " + this.newResidualSS);
        } while (Math.abs(oldWeightedResidualSS - newWeightedResidualSS) > 1.0E-6);
        System.out.println("ended: " + (oldWeightedResidualSS - newWeightedResidualSS));
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
    }

    public Matrix[] weighMatrices(Matrix[] cases, Matrix covar) {
        Matrix[] c = new Matrix[cases.length];
        for (int x = 0; x < cases.length; ++x) {
            c[x] = covar.multiply(cases[x]);
        }
        return c;
    }

    public Matrix estimateLMCovarMatrix(Matrix[] cases, boolean identityDimCovarMatrix) {
        int dim = cases[0].getRowDimension();
        Matrix out = new Matrix(dim, dim);
        double trace = 0.0;
        trace = identityDimCovarMatrix ? (double)dim : this.estimateDimCovarMatrix(cases).getTrace();
        for (int x = 0; x < cases.length; ++x) {
            out = out.add(cases[x].multiply(cases[x].transpose()).scalarMultiply(1.0 / trace));
        }
        return out.scalarMultiply(1.0 / (double)(cases.length * cases[0].getColumnDimension()));
    }

    public Matrix estimateDimCovarMatrix(Matrix[] cases) {
        int dim = cases[0].getColumnDimension();
        Matrix out = new Matrix(dim, dim);
        for (int x = 0; x < cases.length; ++x) {
            out = out.add(cases[x].transpose().multiply(cases[x]));
        }
        return out.scalarMultiply(1.0 / (double)(cases.length * cases[0].getRowDimension()));
    }
}

