/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.DotProduct;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Procrustes;
import commonSense.stats.StatUtils;

public class ResistantFit
extends Procrustes {
    protected double scaling = 0.0;
    protected double rotation = 0.0;
    protected double[] translationVector = new double[]{0.0, 0.0};
    Matrix[] a;

    protected ResistantFit() {
    }

    public ResistantFit(Matrix[] cases) {
        super(cases);
        this.a = this.getShapeMatrices();
        this.scaling = this.scaleFactor(this.a[0], this.a[1]);
        this.a[1] = ResistantFit.scale(this.a[1], 1.0 / this.scaling);
        this.rotation = this.rotationAngle(this.a[0], this.a[1]);
        this.a[1] = ResistantFit.rotateAngle(this.a[1], this.rotation);
        this.translationVector = this.translationVector(this.a[0], this.a[1]);
        this.a[1] = ResistantFit.translate(this.a[1], this.translationVector);
    }

    public double[] translationVector(Matrix one, Matrix two) {
        Matrix T = one.subtract(two.multiply(ResistantFit.getRotationMatrix(this.rotation)).scalarMultiply(this.scaling));
        double[] vec = new double[]{-StatUtils.percentile(T.getColumn(0), 50.0), -StatUtils.percentile(T.getColumn(1), 50.0)};
        return vec;
    }

    public double rotationAngle(Matrix one, Matrix two) {
        int rows = one.getRowDimension();
        double[] angles = new double[rows - 1];
        double[] medians = new double[rows];
        int count = 0;
        Object dp = null;
        for (int i = 0; i < rows; ++i) {
            count = 0;
            for (int j = 0; j < rows; ++j) {
                if (i == j) continue;
                Matrix vOne = one.getRowMatrix(i).subtract(one.getRowMatrix(j));
                Matrix vTwo = two.getRowMatrix(i).subtract(two.getRowMatrix(j));
                angles[count] = new DotProduct(vTwo.getRow(0), vOne.getRow(0)).getSignedAngle();
                ++count;
            }
            medians[i] = StatUtils.percentile(angles, 50.0);
        }
        return StatUtils.percentile(medians, 50.0);
    }

    public double scaleFactor(Matrix one, Matrix two) {
        int rows = one.getRowDimension();
        double[] tau = new double[rows - 1];
        double[] medians = new double[rows];
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            count = 0;
            for (int j = 0; j < rows; ++j) {
                if (i == j) continue;
                Matrix top = one.getRowMatrix(i).subtract(one.getRowMatrix(j));
                Matrix under = two.getRowMatrix(i).subtract(two.getRowMatrix(j));
                tau[count] = StrictMath.sqrt(top.multiply(top.transpose()).getEntry(0, 0) / under.multiply(under.transpose()).getEntry(0, 0));
                ++count;
            }
            medians[i] = StatUtils.percentile(tau, 50.0);
        }
        return 1.0 / StatUtils.percentile(medians, 50.0);
    }

    public int sum(int x) {
        int y = x;
        for (int i = 0; i < x; ++i) {
            y += i;
        }
        return y;
    }
}

