/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Geometrics;

public class LowMemoryTest {
    double[][] originalData = new double[][]{{9.0, 10.0}, {11.0, 7.0}, {7.0, 4.0}, {12.0, 4.0}};
    Matrix original = new Matrix(this.originalData);
    double[][] originalData2 = new double[][]{{9.5, 10.1}, {11.5, 7.7}, {6.9, 4.9}, {11.0, 3.0}};
    Matrix original2 = new Matrix(this.originalData2);
    double[][] alignedData = new double[][]{{10.82104068, 10.09529983}, {12.72505507, 6.616114688}, {2.575113604, 4.191514038}, {13.53325528, 3.232800867}};
    Matrix alignedhand = new Matrix(this.alignedData);

    public LowMemoryTest() {
        System.out.println(this.original.toSquareString());
        System.out.println(this.original2.toSquareString());
        Matrix aligned = Geometrics.scale(Geometrics.rotateAngle(Geometrics.center(this.original), 0.453785606), 0.5882352941176471);
        System.out.println(aligned.toSquareString());
        double diff = Geometrics.calculateCentroidSize(aligned) / Geometrics.calculateCentroidSize(Geometrics.center(this.original));
        Matrix rotation = Geometrics.getRotationMatrix(aligned, this.original);
        Matrix translation = Geometrics.estimateTranslationMatrix(Geometrics.center(this.original), this.original);
        System.out.println(translation.toSquareString());
        Matrix unscaled = Geometrics.scale(aligned, diff);
        System.out.println(unscaled.toSquareString());
        Matrix unrotated = Geometrics.rotate(unscaled, rotation);
        System.out.println(unrotated.toSquareString());
        Matrix uncentered = Geometrics.translate(unrotated, translation);
        System.out.println(uncentered.toSquareString());
        diff = Geometrics.calculateCentroidSize(Geometrics.center(this.original)) / Geometrics.calculateCentroidSize(aligned);
        rotation = Geometrics.getRotationMatrix(this.original, aligned);
        translation = Geometrics.estimateTranslationMatrix(this.original, Geometrics.center(this.original));
        Matrix aligned2 = Geometrics.scale(Geometrics.rotate(Geometrics.translate(this.original2, translation), rotation), diff);
        System.out.println(aligned2.toSquareString());
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("Start Low memory test");
        LowMemoryTest lmt = new LowMemoryTest();
    }
}

