/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.DifferentArrayLengthException;
import commonSense.math.linear.EigenvalueDecomposition;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.SingularValueDecomposition;
import commonSense.stats.StatUtils;
import commonSense.stats.descriptive.matrix.SpecialMatrices;

public class Geometrics {
    protected Geometrics() {
    }

    public static Matrix[] center(Matrix[] m) {
        Matrix IP = Geometrics.getIPMatrix(m[0].getRowDimension());
        Matrix[] c = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            c[i] = Geometrics.center(m[i], IP);
        }
        return c;
    }

    public static Matrix center(Matrix m) {
        return Geometrics.center(m, Geometrics.getIPMatrix(m.getRowDimension()));
    }

    protected static Matrix center(Matrix m, Matrix IP) {
        return m.preMultiply(IP);
    }

    public static Matrix getIPMatrix(int dim) {
        double[][] IP = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                IP[i][j] = (double)(i == j ? 1 : 0) - 1.0 / (double)dim;
            }
        }
        return new Matrix(IP);
    }

    public static Matrix[] translate(Matrix[] m, double[] vector) {
        Matrix[] t = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            t[i] = Geometrics.translate(m[i], vector);
        }
        return t;
    }

    public static Matrix[] translate(Matrix[] m, Matrix[] vector) {
        if (m.length != vector.length) {
            throw new DifferentArrayLengthException("Matrices are of different length");
        }
        Matrix[] t = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            t[i] = Geometrics.translate(m[i], vector[i].getRow(0));
        }
        return t;
    }

    public static Matrix translate(Matrix m, double[] vector) {
        if (m.getColumnDimension() != vector.length) {
            throw new DifferentArrayLengthException("Number of rows in the matrix differs from length of translation vector");
        }
        return SpecialMatrices.columnWiseResiduals(m, vector);
    }

    public static Matrix translate(Matrix m, Matrix translation) {
        if (m.getColumnDimension() != translation.getColumnDimension()) {
            throw new DifferentArrayLengthException("Number of rows in the matrices are of different length!");
        }
        return Geometrics.translate(m, translation.getRow(0));
    }

    public static Matrix estimateTranslationMatrix(Matrix originalMatrix, Matrix translatedMatrix) {
        return originalMatrix.subtract(translatedMatrix);
    }

    public static Matrix estimateTranslationVector(Matrix originalMatrix, Matrix translatedMatrix) {
        return originalMatrix.subtract(translatedMatrix).getRowMatrix(0);
    }

    public static Matrix[] scaleCentroid(Matrix[] m) {
        Matrix[] s = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            s[i] = Geometrics.scaleCentroid(m[i]);
        }
        return s;
    }

    public static Matrix scaleCentroid(Matrix m) {
        return Geometrics.scale(m, Geometrics.calculateCentroidSize(m));
    }

    public static Matrix[] scale(Matrix[] m, double[] sizes) {
        if (m.length != sizes.length) {
            throw new DifferentArrayLengthException("Matrices are of different length");
        }
        Matrix[] s = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            s[i] = Geometrics.scale(m[i], sizes[i]);
        }
        return s;
    }

    public static Matrix scale(Matrix m, double size) {
        return m.scalarMultiply(1.0 / size);
    }

    public static double[] calculateCentroidSizes(Matrix[] m) {
        double[] c = new double[m.length];
        for (int i = 0; i < m.length; ++i) {
            c[i] = Geometrics.calculateCentroidSize(m[i]);
        }
        return c;
    }

    public static double calculateCentroidSize(Matrix m) {
        return StrictMath.sqrt(m.multiply(m.transpose()).getTrace());
    }

    public static double calculateProcrustesDistance(Matrix m1, Matrix m2) {
        Matrix md = m1.subtract(m2);
        return Geometrics.calculateCentroidSize(md);
    }

    public static double[] calculateProcrustesDistances(Matrix[] m) {
        int comb = m.length * (m.length + 1) / 2;
        double[] values = new double[comb];
        Matrix md = null;
        int count = 0;
        for (int x = 0; x < m.length - 1; ++x) {
            for (int y = x + 1; y < m.length; ++y) {
                md = m[x].subtract(m[y]);
                values[count] = Geometrics.calculateCentroidSize(md);
                ++count;
            }
        }
        return values;
    }

    public static double[] calculateSquaredLMProcrustesDistances(Matrix m1, Matrix m2) {
        Matrix md = m1.subtract(m2);
        Matrix SSCP = md.multiply(md.transpose());
        int dim = md.getRowDimension();
        double[] dis = new double[dim];
        for (int x = 0; x < dim; ++x) {
            dis[x] = SSCP.getEntry(x, x);
        }
        return dis;
    }

    public static double[] calculateMeanSquaredProcrustesDistances(Matrix m1, Matrix[] m2) {
        int dim = m1.getRowDimension();
        double[] dis = new double[dim];
        for (int x = 0; x < dim; ++x) {
            dis[x] = 0.0;
        }
        Matrix md = null;
        Matrix SSCP = null;
        for (int x = 0; x < m2.length; ++x) {
            md = m1.subtract(m2[x]);
            SSCP = md.multiply(md.transpose());
            for (int y = 0; y < dim; ++y) {
                int n = y;
                dis[n] = dis[n] + (SSCP.getEntry(y, y) - dis[y]) / ((double)x + 1.0);
            }
        }
        return dis;
    }

    public static double[] calculateMeanSquaredProcrustesDistances(Matrix[] m2) {
        Matrix m1 = Geometrics.estimateMean(m2);
        return Geometrics.calculateMeanSquaredProcrustesDistances(m1, m2);
    }

    public static double[] calculateSquaredProcrustesDistanceVariances(Matrix[] m2) {
        Matrix m1 = Geometrics.estimateMean(m2);
        return Geometrics.calculateSquaredProcrustesDistanceVariances(m1, m2);
    }

    public static double[] calculateSquaredProcrustesDistanceVariances(Matrix m1, Matrix[] m2) {
        int dim = m1.getRowDimension();
        double[] dis = new double[dim];
        double[] var = new double[dim];
        for (int x = 0; x < dim; ++x) {
            dis[x] = 0.0;
            var[x] = 0.0;
        }
        Matrix md = null;
        Matrix SSCP = null;
        double dev = 0.0;
        double nDev = 0.0;
        for (int x = 0; x < m2.length; ++x) {
            md = m1.subtract(m2[x]);
            SSCP = md.multiply(md.transpose());
            int y = 0;
            while (y < dim) {
                dev = SSCP.getEntry(y, y) - dis[y];
                nDev = dev / (double)(x + 1);
                int n = y;
                dis[n] = dis[n] + nDev;
                int n2 = y++;
                var[n2] = var[n2] + (double)x * dev * nDev;
            }
        }
        for (int y = 0; y < dim; ++y) {
            var[y] = var[y] / (double)(m2.length - 1);
        }
        return var;
    }

    public static Matrix estimateMean(Matrix[] all) {
        Matrix mean = new Matrix(all[0].getRowDimension(), all[0].getColumnDimension(), 0.0);
        Matrix diff = null;
        Matrix nDiff = null;
        for (int x = 0; x < all.length; ++x) {
            diff = all[x].subtract(mean);
            nDiff = diff.scalarMultiply(1.0 / ((double)x + 1.0));
            mean = mean.add(nDiff);
        }
        return mean;
    }

    public static double[] calculateSignedPointDistances(Matrix m1, Matrix m2) {
        Matrix md = m1.subtract(m2);
        int dim = md.getRowDimension();
        double[] dis = new double[dim];
        for (int x = 0; x < dim; ++x) {
            dis[x] = StatUtils.sum(md.getRow(x));
        }
        return dis;
    }

    public static Matrix[] rotate(Matrix[] m) {
        Matrix[] r = new Matrix[m.length];
        r[0] = m[0].copy();
        for (int i = 1; i < m.length; ++i) {
            r[i] = Geometrics.rotateRef(m[i], m[0]);
        }
        return r;
    }

    public static Matrix[] rotateRef(Matrix[] target, Matrix reference) {
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = Geometrics.rotateRef(target[i], reference);
        }
        return r;
    }

    public static Matrix[] rotate(Matrix[] target, Matrix[] rotationMatrices) {
        if (target.length != rotationMatrices.length) {
            throw new DifferentArrayLengthException("Matrices are of different length");
        }
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = target[i].multiply(rotationMatrices[i]);
        }
        return r;
    }

    public static Matrix rotateRef(Matrix target, Matrix reference) {
        return target.multiply(Geometrics.getRotationMatrix(target, reference));
    }

    public static Matrix rotate(Matrix target, Matrix rotationMatrix) {
        return target.multiply(rotationMatrix);
    }

    public static Matrix rotateAngle(Matrix m, double angle) {
        return m.multiply(Geometrics.getRotationMatrix(angle));
    }

    public static Matrix[] getRotationMatrices(Matrix[] target, Matrix reference) {
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = Geometrics.getRotationMatrix(target[i], reference);
        }
        return r;
    }

    public static Matrix getRotationMatrix(Matrix m, Matrix reference) {
        SingularValueDecomposition sigma = new SingularValueDecomposition(reference.transpose().multiply(m));
        double[] singularValues = sigma.getSingularValues();
        double[][] s = new double[singularValues.length][singularValues.length];
        for (int i = 0; i < singularValues.length; ++i) {
            s[i][i] = singularValues[i] < 0.0 ? -1.0 : (singularValues[i] > 0.0 ? 1.0 : 1.0);
        }
        return sigma.getV().multiply(new Matrix(s)).multiply(sigma.getU().transpose());
    }

    public static Matrix getRotationMatrix(double angle) {
        double[][] h = new double[2][2];
        double d = StrictMath.cos(angle);
        h[1][1] = d;
        h[0][0] = d;
        h[1][0] = StrictMath.sin(angle);
        h[0][1] = -h[1][0];
        return new Matrix(h);
    }

    public static double getAngle(Matrix rotationMatrix) {
        if (rotationMatrix.getColumnDimension() != 2) {
            throw new IllegalArgumentException("Matrix dimentionality mismatch!");
        }
        return (rotationMatrix.getEntry(1, 0) < 0.0 ? -1.0 : 1.0) * StrictMath.acos(rotationMatrix.getEntry(0, 0));
    }

    public static Matrix getMaxRotationMatrix(Matrix Y) {
        return Geometrics.rotateAngle(new EigenvalueDecomposition(Y.transpose().multiply(Y)).getV(), 90.0);
    }

    public static Matrix getNormalisedEigenvectors(Matrix Y) {
        return Geometrics.getMaxRotationMatrix(Y);
    }

    public static Matrix[] uniformShapeChange(Matrix[] m) {
        Matrix[] r = new Matrix[m.length];
        for (int i = 0; i < m.length; ++i) {
            r[i] = Geometrics.uniformShapeChange(m[i], m[0]);
        }
        return r;
    }

    public static Matrix[] uniformShapeChange(Matrix[] target, Matrix reference) {
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = Geometrics.uniformShapeChange(target[i], reference);
        }
        return r;
    }

    public static Matrix[] uniformShapeChange(Matrix[] target, Matrix[] affineTransformationMatrices) {
        if (target.length != affineTransformationMatrices.length) {
            throw new DifferentArrayLengthException("Matrices are of different length");
        }
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = target[i].multiply(affineTransformationMatrices[i]);
        }
        return r;
    }

    public static Matrix uniformShapeChange(Matrix target, Matrix reference) {
        return target.multiply(Geometrics.getUniformShapeChangeMatrix(target, reference));
    }

    public static Matrix[] getUniformShapeChangeMatrices(Matrix[] target, Matrix reference) {
        Matrix[] r = new Matrix[target.length];
        for (int i = 0; i < target.length; ++i) {
            r[i] = Geometrics.getUniformShapeChangeMatrix(target[i], reference);
        }
        return r;
    }

    public static Matrix getUniformShapeChangeMatrix(Matrix target, Matrix reference) {
        return target.transpose().multiply(target).inverse().multiply(target.transpose().multiply(reference));
    }

    public static Matrix[] tangentSpaceProjection(Matrix[] original) {
        Matrix combined = Geometrics.combineSpecimenMatrices(original);
        return Geometrics.createSpecimenMatrices(Geometrics.tangentSpaceProjection(combined));
    }

    public static Matrix tangentSpaceProjection(Matrix original) {
        Matrix means = Matrix.createRowMatrix(original.columnMeans());
        Matrix meansT = means.transpose();
        return original.multiply(Matrix.getIdentity(original.getColumnDimension()).subtract(meansT.multiply(means.multiply(meansT).inverse()).multiply(means)));
    }

    public static Matrix[] createSpecimenMatrices(Matrix m) {
        return Geometrics.createSpecimenMatrices(m.getData());
    }

    public static Matrix[] createSpecimenMatrices(double[][] values) {
        int N = values.length;
        int LM = values[0].length / 2;
        Matrix[] m = new Matrix[N];
        for (int x = 0; x < N; ++x) {
            m[x] = new Matrix(LM, 2);
            for (int y = 0; y < LM; ++y) {
                m[x].setEntry(y, 0, values[x][y * 2]);
                m[x].setEntry(y, 1, values[x][y * 2 + 1]);
            }
        }
        return m;
    }

    public static Matrix combineSpecimenMatrices(Matrix[] m) {
        int N = m.length;
        int LM = m[0].getRowDimension();
        double[][] values = new double[N][LM * 2];
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                values[x][y * 2] = m[x].getEntry(y, 0);
                values[x][y * 2 + 1] = m[x].getEntry(y, 1);
            }
        }
        return new Matrix(values);
    }

    public static Matrix[] createLMMatrices(Matrix m) {
        return Geometrics.createLMMatrices(m.getData());
    }

    public static Matrix[] createLMMatrices(double[][] values) {
        int x;
        int N = values.length;
        int LM = values[0].length / 2;
        Matrix[] m = new Matrix[LM];
        for (x = 0; x < LM; ++x) {
            m[x] = new Matrix(N, 2);
        }
        for (x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                m[y].setEntry(x, 0, values[x][y * 2]);
                m[y].setEntry(x, 1, values[x][y * 2 + 1]);
            }
        }
        return m;
    }

    public static Matrix combineLMMatrices(Matrix[] m) {
        int LM = m.length;
        int N = m[0].getRowDimension();
        double[][] values = new double[N][LM * 2];
        for (int x = 0; x < N; ++x) {
            for (int y = 0; y < LM; ++y) {
                values[x][y * 2] = m[y].getEntry(x, 0);
                values[x][y * 2 + 1] = m[y].getEntry(x, 1);
            }
        }
        return new Matrix(values);
    }
}

