/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Procrustes;

public class GeneralizedProcrustes
extends Procrustes {
    protected GeneralizedProcrustes() {
    }

    public GeneralizedProcrustes(Matrix[] cases) {
        this(cases, 0.001, false);
    }

    public GeneralizedProcrustes(Matrix[] cases, boolean maxVarianceRotation) {
        this(cases, 0.001, maxVarianceRotation);
    }

    public GeneralizedProcrustes(Matrix[] cases, double tolerance) {
        this(cases, tolerance, false);
    }

    public GeneralizedProcrustes(Matrix[] cases, double tolerance, boolean maxVarianceRotation) {
        super(cases);
        System.out.println("Start GPA");
        this.tolerance = tolerance;
        this.iteration();
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
        System.out.println("Finished GPA");
    }

    protected void iteration() {
        int i;
        int iteration = 0;
        this.newScaleFactor = new double[this.N];
        this.oldScaleFactor = new double[this.N];
        this.estimateConcensus(this.shape);
        this.estimateResidualSS();
        System.out.println("(GPA) Residual SS(" + iteration + "): " + this.newResidualSS);
        for (i = 0; i < this.N; ++i) {
            this.newScaleFactor[i] = 1.0;
        }
        do {
            this.oldResidualSS = this.newResidualSS;
            System.arraycopy(this.newScaleFactor, 0, this.oldScaleFactor, 0, this.oldScaleFactor.length);
            this.rotate();
            for (i = 0; i < this.N; ++i) {
                this.shape[i].scalarMultiply(this.newScaleFactor[i]);
            }
            this.estimateConcensus(this.shape);
            this.estimateScaleFactors(this.shape, this.consensus);
            for (i = 0; i < this.N; ++i) {
                this.shape[i] = this.shape[i].scalarMultiply(this.newScaleFactor[i] / this.oldScaleFactor[i]);
            }
            this.estimateConcensus(this.shape);
            this.estimateResidualSS();
            System.out.println("(GPA) Residual SS(" + ++iteration + "): " + this.newResidualSS + " dif: " + Math.abs(this.oldResidualSS - this.newResidualSS));
        } while (iteration <= 10 && Math.abs(this.oldResidualSS - this.newResidualSS) > this.tolerance);
        for (i = 0; i < this.N; ++i) {
            this.centroidSize[i] = this.centroidSize[i] / this.oldScaleFactor[i];
        }
    }

    @Override
    protected void maxVarianceRotation() {
        Matrix eigen = GeneralizedProcrustes.getMaxRotationMatrix(this.consensus);
        System.out.println(eigen.toSquareString(" "));
        System.out.println(this.consensus.toSquareString(" "));
        this.consensus = this.consensus.multiply(eigen);
        System.out.println(this.consensus.toSquareString(" "));
        for (int x = 0; x < this.N; ++x) {
            this.shape[x] = this.shape[x].multiply(eigen);
            this.shapeSize[x] = this.shapeSize[x].multiply(eigen);
        }
    }
}

