/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.GeneralizedProcrustes;

public class GeneralizedObliqueProcrustes
extends GeneralizedProcrustes {
    protected GeneralizedObliqueProcrustes() {
    }

    public GeneralizedObliqueProcrustes(Matrix[] cases) {
        this(cases, 0.001, false);
    }

    public GeneralizedObliqueProcrustes(Matrix[] cases, boolean maxVarianceRotation) {
        this(cases, 0.001, maxVarianceRotation);
    }

    public GeneralizedObliqueProcrustes(Matrix[] cases, double tolerance) {
        this(cases, tolerance, false);
    }

    public GeneralizedObliqueProcrustes(Matrix[] cases, double tolerance, boolean maxVarianceRotation) {
        super(cases, tolerance, maxVarianceRotation);
        System.out.println("Start GOPA");
        this.affineIteration();
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
    }

    protected void affineIteration() {
        int i;
        int iteration = 0;
        this.estimateConcensus(this.shape);
        this.estimateResidualSS();
        System.out.println("(GOPA) Residual SS(" + iteration + "): " + this.newResidualSS);
        Matrix oldConsensus = null;
        double scaleFactor = 1.0;
        do {
            this.oldResidualSS = this.newResidualSS;
            this.uniformShapeChange();
            oldConsensus = this.consensus.copy();
            this.estimateConcensus(this.affine);
            scaleFactor = this.estimateScaleFactor(oldConsensus, this.consensus);
            for (i = 0; i < this.N; ++i) {
                this.shape[i] = this.shape[i].scalarMultiply(scaleFactor);
                this.affine[i] = this.affine[i].scalarMultiply(scaleFactor);
            }
            this.estimateConcensus(this.affine);
            this.estimateResidualSS();
            System.out.println("(GOPA) Residual SS(" + ++iteration + "): " + this.newResidualSS + " dif: " + Math.abs(this.oldResidualSS - this.newResidualSS));
            System.out.println(this.consensus.toSquareString(" "));
        } while (iteration <= 10 && Math.abs(this.oldResidualSS - this.newResidualSS) > this.tolerance);
        for (i = 0; i < this.N; ++i) {
            this.centroidSize[i] = this.centroidSize[i] / this.oldScaleFactor[i];
        }
    }

    @Override
    protected void maxVarianceRotation() {
        Matrix eigen = GeneralizedObliqueProcrustes.getMaxRotationMatrix(this.consensus);
        this.consensus = this.consensus.multiply(eigen);
        for (int x = 0; x < this.N; ++x) {
            this.shape[x] = this.shape[x].multiply(eigen);
            this.shapeSize[x] = this.shapeSize[x].multiply(eigen);
        }
    }
}

