/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.DoubleProcrustes;

public class DoubleGeneralizedProcrustes
extends DoubleProcrustes {
    protected DoubleGeneralizedProcrustes() {
    }

    public DoubleGeneralizedProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases) {
        this(alignmentCases, dataAnalysisCases, 0.001, false);
    }

    public DoubleGeneralizedProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, double tolerance) {
        this(alignmentCases, dataAnalysisCases, tolerance, false);
    }

    public DoubleGeneralizedProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, boolean maxVarianceRotation) {
        this(alignmentCases, dataAnalysisCases, 0.001, maxVarianceRotation);
    }

    public DoubleGeneralizedProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, double tolerance, boolean maxVarianceRotation) {
        super(alignmentCases, dataAnalysisCases);
        this.tolerance = tolerance;
        this.iteration();
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
    }

    protected void iteration() {
        int i;
        int iteration = 0;
        this.newScaleFactor = new double[this.N];
        this.oldScaleFactor = new double[this.N];
        this.estimateConcensus(this.shapeA);
        this.estimateResidualSS();
        for (i = 0; i < this.N; ++i) {
            this.newScaleFactor[i] = 1.0;
        }
        do {
            this.oldResidualSS = this.newResidualSS;
            System.arraycopy(this.newScaleFactor, 0, this.oldScaleFactor, 0, this.oldScaleFactor.length);
            this.rotate();
            for (i = 0; i < this.N; ++i) {
                this.shapeA[i].scalarMultiply(this.newScaleFactor[i]);
                this.shape[i].scalarMultiply(this.newScaleFactor[i]);
            }
            this.estimateConcensus(this.shapeA);
            this.estimateScaleFactors(this.shapeA, this.consensus);
            for (i = 0; i < this.N; ++i) {
                this.shape[i] = this.shape[i].scalarMultiply(this.newScaleFactor[i] / this.oldScaleFactor[i]);
                this.shapeA[i] = this.shapeA[i].scalarMultiply(this.newScaleFactor[i] / this.oldScaleFactor[i]);
            }
            this.estimateConcensus(this.shapeA);
            this.estimateResidualSS();
        } while (++iteration <= 50 && Math.abs(this.oldResidualSS - this.newResidualSS) > this.tolerance);
        for (i = 0; i < this.N; ++i) {
            this.centroidSize[i] = this.centroidSize[i] / this.oldScaleFactor[i];
        }
    }

    @Override
    protected void maxVarianceRotation() {
        Matrix eigen = DoubleGeneralizedProcrustes.getMaxRotationMatrix(this.consensus);
        this.consensus = this.consensus.multiply(eigen);
        for (int x = 0; x < this.N; ++x) {
            this.shape[x] = this.shape[x].multiply(eigen);
            this.shapeSize[x] = this.shapeSize[x].multiply(eigen);
            this.shapeA[x] = this.shapeA[x].multiply(eigen);
            this.shapeSizeA[x] = this.shapeSizeA[x].multiply(eigen);
        }
    }
}

