/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.DoubleGeneralizedProcrustes;
import commonSense.math.linear.geometrics.DoubleObliqueProcrustes;

public class DoubleGeneralizedObliqueProcrustes
extends DoubleObliqueProcrustes {
    protected DoubleGeneralizedObliqueProcrustes() {
    }

    public DoubleGeneralizedObliqueProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases) {
        this(alignmentCases, dataAnalysisCases, 0.001, false);
    }

    public DoubleGeneralizedObliqueProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, boolean maxVarianceRotation) {
        this(alignmentCases, dataAnalysisCases, 0.001, maxVarianceRotation);
    }

    public DoubleGeneralizedObliqueProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, double tolerance) {
        this(alignmentCases, dataAnalysisCases, tolerance, false);
    }

    public DoubleGeneralizedObliqueProcrustes(Matrix[] alignmentCases, Matrix[] dataAnalysisCases, double tolerance, boolean maxVarianceRotation) {
        this.copy(new DoubleGeneralizedProcrustes(alignmentCases, dataAnalysisCases, tolerance, maxVarianceRotation));
        this.tolerance = tolerance;
        System.out.println("Start DGOPA");
        this.doubleAffineIteration();
        this.restoreSize();
        if (maxVarianceRotation) {
            this.maxVarianceRotation();
        }
    }

    protected void copy(DoubleGeneralizedProcrustes dgp) {
        this.N = dgp.N;
        this.centered = dgp.getCenteredMatrices();
        this.centeredA = dgp.getCenteredAnalysisMatrices();
        this.translation = dgp.getTranslationMatrices();
        this.preShape = dgp.getPreShapeMatrices();
        this.preShapeA = dgp.getPreShapeAnalysisMatrices();
        this.centroidSize = dgp.getCentroidSizes();
        this.shape = dgp.getShapeMatrices();
        this.shapeA = dgp.getShapeAnalysisMatrices();
        this.shapeSize = dgp.getShapeSizeMatrices();
        this.shapeSizeA = dgp.getShapeSizeAnalysisMatrices();
        this.affine = new Matrix[this.N];
        this.affineA = new Matrix[this.N];
        this.affineSize = new Matrix[this.N];
        this.affineSizeA = new Matrix[this.N];
    }

    protected void doubleAffineIteration() {
        int i;
        int iteration = 0;
        this.estimateConcensus(this.shapeA);
        this.estimateResidualSS();
        System.out.println("(DGOPA) Residual SS(" + iteration + "): " + this.newResidualSS);
        Matrix oldConsensus = null;
        double scaleFactor = 1.0;
        do {
            this.oldResidualSS = this.newResidualSS;
            this.uniformShapeChange();
            oldConsensus = this.consensus.copy();
            this.estimateConcensus(this.affineA);
            scaleFactor = this.estimateScaleFactor(oldConsensus, this.consensus);
            for (i = 0; i < this.N; ++i) {
                this.shape[i] = this.shape[i].scalarMultiply(scaleFactor);
                this.affine[i] = this.affine[i].scalarMultiply(scaleFactor);
                this.shapeA[i] = this.shapeA[i].scalarMultiply(scaleFactor);
                this.affineA[i] = this.affineA[i].scalarMultiply(scaleFactor);
            }
            this.estimateConcensus(this.affineA);
            this.estimateResidualSS();
            System.out.println("(DGOPA) Residual SS(" + ++iteration + "): " + this.newResidualSS + " dif: " + Math.abs(this.oldResidualSS - this.newResidualSS) + " with " + this.tolerance + " results in " + (Math.abs(this.oldResidualSS - this.newResidualSS) > this.tolerance));
        } while (iteration <= 10 && Math.abs(this.oldResidualSS - this.newResidualSS) > this.tolerance);
        for (i = 0; i < this.N; ++i) {
            this.centroidSize[i] = this.centroidSize[i] / scaleFactor;
        }
    }

    @Override
    protected void maxVarianceRotation() {
        Matrix eigen = DoubleGeneralizedObliqueProcrustes.getMaxRotationMatrix(this.consensus);
        this.consensus = this.consensus.multiply(eigen);
        for (int x = 0; x < this.N; ++x) {
            this.shape[x] = this.shape[x].multiply(eigen);
            this.shapeSize[x] = this.shapeSize[x].multiply(eigen);
        }
    }
}

