/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear.geometrics;

import commonSense.math.linear.Matrix;
import commonSense.math.linear.geometrics.Geometrics;

public abstract class AbstractProcrustes
extends Geometrics {
    protected double[] oldScaleFactor;
    protected double[] newScaleFactor;
    protected double oldResidualSS;
    protected double newResidualSS;
    protected double tolerance;
    protected Matrix[] affine;
    protected Matrix[] affineSize;
    protected Matrix[] uniform;
    protected Matrix[] raw;
    protected Matrix[] centered;
    protected Matrix[] translation;
    protected Matrix[] preShape;
    protected Matrix[] shape;
    protected Matrix[] rotations;
    protected Matrix consensus;
    protected Matrix[] shapeSize;
    protected double[] centroidSize;
    protected int N;

    protected AbstractProcrustes() {
    }

    protected void init(Matrix[] cases) {
        this.N = cases.length;
        this.raw = cases;
        this.translation = new Matrix[this.N];
        this.centered = new Matrix[this.N];
        this.preShape = new Matrix[this.N];
        this.rotations = new Matrix[this.N];
        this.shapeSize = new Matrix[this.N];
        this.centroidSize = new double[this.N];
        this.shape = new Matrix[this.N];
    }

    protected void center() {
        this.centered = AbstractProcrustes.center(this.raw);
        for (int i = 0; i < this.N; ++i) {
            this.translation[i] = this.raw[i].subtract(this.centered[i]).getRowMatrix(0);
        }
    }

    protected void translate(double[] center) {
        this.centered = AbstractProcrustes.translate(this.raw, center);
    }

    public Matrix[] getCenteredMatrices() {
        return this.copy(this.centered);
    }

    public Matrix[] getTranslationMatrices() {
        return this.copy(this.translation);
    }

    protected void scale() {
        this.centroidSize = AbstractProcrustes.calculateCentroidSizes(this.centered);
        for (int i = 0; i < this.N; ++i) {
            this.preShape[i] = AbstractProcrustes.scale(this.centered[i], this.centroidSize[i]);
        }
    }

    public Matrix[] getPreShapeMatrices() {
        return this.copy(this.preShape);
    }

    public double[] getCentroidSizes() {
        return this.centroidSize;
    }

    protected void rotate() {
        this.shape = AbstractProcrustes.rotateRef(this.preShape, this.consensus);
    }

    public Matrix[] getShapeMatrices() {
        return this.copy(this.shape);
    }

    public Matrix[] getRotationMatrices() {
        return this.copy(AbstractProcrustes.getRotationMatrices(this.preShape, this.consensus));
    }

    protected void uniformShapeChange() {
        this.affine = AbstractProcrustes.uniformShapeChange(this.shape, this.consensus);
    }

    public Matrix[] getAffineMatrices() {
        return this.copy(this.affine);
    }

    public Matrix[] getUniformShapeChangeMatrices() {
        return this.copy(this.uniform);
    }

    protected void restoreSize() {
        for (int i = 0; i < this.N; ++i) {
            this.shapeSize[i] = this.shape[i].scalarMultiply(this.centroidSize[i]);
        }
    }

    public Matrix[] getShapeSizeMatrices() {
        return this.copy(this.shapeSize);
    }

    public Matrix[] getAffineSizeMatrices() {
        return this.copy(this.affineSize);
    }

    protected void estimateConcensus(Matrix[] all) {
        this.consensus = AbstractProcrustes.estimateMean(all);
    }

    public Matrix getConsensus() {
        return this.consensus;
    }

    protected void estimateScaleFactors(Matrix[] all, Matrix ref) {
        for (int i = 0; i < all.length; ++i) {
            this.newScaleFactor[i] = this.oldScaleFactor[i] * this.estimateScaleFactor(all[i], ref);
        }
    }

    protected double estimateScaleFactor(Matrix mean, Matrix ref) {
        return StrictMath.sqrt(mean.multiply(ref.transpose()).getTrace() / (mean.multiply(mean.transpose()).getTrace() * ref.multiply(ref.transpose()).getTrace()));
    }

    protected void estimateResidualSS() {
        this.newResidualSS = (double)this.N * (1.0 - this.consensus.multiply(this.consensus.transpose()).getTrace());
    }

    public double getResidualSS() {
        return this.newResidualSS;
    }

    protected Matrix[] copy(Matrix[] in) {
        Matrix[] out = new Matrix[in.length];
        System.arraycopy(in, 0, out, 0, in.length);
        return out;
    }

    protected void maxVarianceRotation() {
        Matrix eigen = AbstractProcrustes.getMaxRotationMatrix(this.consensus);
        this.consensus = this.consensus.multiply(eigen);
        for (int x = 0; x < this.N; ++x) {
            this.shape[x] = this.shape[x].multiply(eigen);
            this.shapeSize[x] = this.shapeSize[x].multiply(eigen);
        }
    }
}

