/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.math.linear.InvalidMatrixException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.MatrixIndexException;
import java.io.Serializable;

public class MatrixArray
extends Matrix
implements Serializable {
    static final long serialVersionUID = 4237564493130426188L;
    private double[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;

    public MatrixArray() {
    }

    public MatrixArray(int rowDimension, int columnDimension) {
        this.data = new double[rowDimension][columnDimension];
        this.lu = null;
    }

    public MatrixArray(double[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public MatrixArray(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    public double[][] copyArray() {
        return this.copyOut();
    }

    public double[][] add(double[][] m) throws IllegalArgumentException {
        if (this.data.length != m.length || this.data[0].length != m[0].length) {
            throw new IllegalArgumentException("double[][] dimension mismatch");
        }
        int rowCount = this.data.length;
        int columnCount = this.data[0].length;
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] + m[row][col];
            }
        }
        return outData;
    }

    public double[][] subtract(double[][] m) throws IllegalArgumentException {
        if (this.data.length != m.length || this.data[0].length != m[0].length) {
            throw new IllegalArgumentException("double[][] dimension mismatch");
        }
        int rowCount = this.data.length;
        int columnCount = this.data[0].length;
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] - m[row][col];
            }
        }
        return outData;
    }

    public double[][] scalarAddArray(double d) {
        int rowCount = this.data.length;
        int columnCount = this.data[0].length;
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] + d;
            }
        }
        return outData;
    }

    public double[][] scalarMultiplyArray(double d) {
        int rowCount = this.data.length;
        int columnCount = this.data[0].length;
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] * d;
            }
        }
        return outData;
    }

    public double[][] multiply(double[][] m) throws IllegalArgumentException {
        if (this.data.length != m[0].length) {
            throw new IllegalArgumentException("Arrays are not multiplication compatible.");
        }
        int nRows = this.data.length;
        int nCols = m[0].length;
        int nSum = this.data[0].length;
        double[][] outData = new double[nRows][nCols];
        double sum = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += this.data[row][i] * m[i][col];
                }
                outData[row][col] = sum;
            }
        }
        return outData;
    }

    public double[][] preMultiply(double[][] m) throws IllegalArgumentException {
        return new MatrixArray(m).multiply(this.data);
    }

    public double[][] transposeArray() {
        int nRows = this.data.length;
        int nCols = this.data[0].length;
        double[][] out = new double[nCols][nRows];
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                out[col][row] = this.data[row][col];
            }
        }
        return out;
    }

    public double[][] inverseArray() throws InvalidMatrixException {
        return this.solve(this.getIdentityArray(this.data.length));
    }

    public double[][] solve(double[][] b) throws IllegalArgumentException, InvalidMatrixException {
        return this.solve(new Matrix(b)).getData();
    }

    public double[][] getSubMatrixArray(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        return this.getSubMatrix(startRow, endRow, startColumn, endColumn).getData();
    }

    public double[][] getSubMatrixArray(int[] rows, int[] columns) throws MatrixIndexException {
        return this.getSubMatrix(rows, columns).getData();
    }

    public double[][] getSubMatrixArray(int startRow, int endRow, int[] columns) throws MatrixIndexException {
        return this.getSubMatrix(startRow, endRow, columns).getData();
    }

    public double[][] getSubMatrixArray(int[] rows, int startColumn, int endColumn) throws MatrixIndexException {
        return this.getSubMatrix(rows, startColumn, endColumn).getData();
    }

    protected double[][] getIdentityArray(int dimension) {
        double[][] out = new double[dimension][dimension];
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col < dimension; ++col) {
                out[row][col] = row == col ? 1.0 : 0.0;
            }
        }
        return out;
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.data.length;
        int nCols = this.data[0].length;
        return row >= 0 && row <= nRows - 1 && col >= 0 && col <= nCols - 1;
    }
}

