/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.math.linear.PointXD;

public class DotProduct {
    double dotProduct = 0.0;
    double normA = 0.0;
    double normB = 0.0;
    double angle = 0.0;
    int sign = 0;

    public DotProduct(double[] vectorA, double[] vectorB) {
        if (vectorA.length != vectorB.length) {
            throw new IllegalArgumentException();
        }
        for (int x = 0; x < vectorA.length; ++x) {
            this.dotProduct += vectorA[x] * vectorB[x];
        }
        this.normA = PointXD.norm(vectorA);
        this.normB = PointXD.norm(vectorB);
        this.angle = DotProduct.angle(this.dotProduct, this.normA, this.normB);
        this.sign = DotProduct.sign(vectorA, vectorB);
    }

    protected static double angle(double dotProduct, double normA, double normB) {
        return StrictMath.acos(dotProduct / (normA * normB));
    }

    protected static int sign(double[] vectorA, double[] vectorB) {
        double b1 = vectorA[0] / vectorA[1];
        double b2 = vectorB[0] / vectorB[1];
        return b1 > b2 ? -1 : 1;
    }

    public double getDotProduct() {
        return this.dotProduct;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getSignedAngle() {
        return (double)this.sign * this.angle;
    }

    public double getSign() {
        return this.sign;
    }
}

