/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.linear;

import commonSense.math.linear.InvalidMatrixException;
import commonSense.math.linear.Matrix;
import commonSense.math.linear.PointXD;
import commonSense.stats.descriptive.matrix.CovarianceMatrix;
import java.awt.geom.Point2D;

public class Distances {
    private Distances() {
    }

    public static double centroidSize(Matrix m) {
        double centroid = 0.0;
        double[][] data = m.getData();
        double[] means = m.columnMeans();
        double temp = 0.0;
        for (int row = 0; row < data.length; ++row) {
            for (int col = 0; col < data[0].length; ++col) {
                temp = data[row][col] - means[col];
                centroid = temp * temp;
            }
        }
        return StrictMath.sqrt(centroid);
    }

    public static double[] mahalanobis(Matrix a, Matrix covar) throws InvalidMatrixException {
        Matrix covarInv = covar.inverse();
        int rows = a.getRowDimension();
        double[] dis = new double[rows];
        for (int row = 0; row < rows; ++row) {
            Matrix dif = a.getRowMatrix(row);
            Matrix difT = dif.transpose();
            dis[row] = dif.multiply(covarInv).multiply(difT).getEntry(0, 0);
            if (!(dis[row] < 0.0)) continue;
            System.out.println("negative distance: " + row + ": " + dis[row]);
            throw new RuntimeException("negative distance: " + row + ": " + dis[row]);
        }
        return dis;
    }

    public static double[] mahalanobis(Matrix a) throws InvalidMatrixException {
        return Distances.mahalanobis(a, new CovarianceMatrix(a, true));
    }

    public static double[] euclidean(Matrix a) {
        double[] means = a.columnMeans();
        int cols = a.getColumnDimension();
        int rows = a.getRowDimension();
        double[] dis = new double[rows];
        Matrix dif = new Matrix(cols, 1);
        for (int row = 0; row < rows; ++row) {
            Matrix in = a.getRowMatrix(row);
            for (int col = 0; col < cols; ++col) {
                dif.setEntry(col, 0, in.getEntry(0, col) - means[col]);
            }
            Matrix difT = dif.transpose();
            dis[row] = dif.multiply(difT).getEntry(0, 0);
        }
        return dis;
    }

    public static double linePoint(double a, double b, double[] p) {
        return StrictMath.abs(b * p[0] - p[1] + a) / StrictMath.sqrt(1.0 + b * b);
    }

    public static double pointPoint(double[] p1, double[] p2) {
        return StrictMath.hypot(p1[0] - p2[0], p1[1] - p2[1]);
    }

    public static double pointPoint(Point2D.Double p1, Point2D.Double p2) {
        return StrictMath.hypot(p1.x - p2.x, p1.y - p2.y);
    }

    public static double pointPoint(PointXD p1, PointXD p2) {
        return StrictMath.hypot(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }
}

