/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.curves;

import commonSense.DifferentArrayLengthException;
import commonSense.math.curves.AbstractSpline;
import commonSense.math.linear.PointXD;
import commonSense.math.polynomial.BernsteinPolynomial;

public class BezierSpline
extends AbstractSpline {
    public BezierSpline() {
        this.n = -1;
    }

    public BezierSpline(double[][] points) {
        this.n = points[0].length - 1;
        for (int x = 0; x < points[0].length; ++x) {
            this.controlPoints.add(x, new PointXD(points[x][0], points[x][1]));
        }
    }

    public BezierSpline(double[] xPoints, double[] yPoints) {
        if (xPoints.length != yPoints.length) {
            throw new DifferentArrayLengthException("Length differ: " + xPoints.length + " versus " + yPoints.length);
        }
        this.n = xPoints.length - 1;
        for (int x = 0; x < xPoints.length; ++x) {
            this.controlPoints.add(x, new PointXD(xPoints[x], yPoints[x]));
        }
    }

    public BezierSpline(PointXD[] points) {
        this.n = points.length - 1;
        for (int x = 0; x < points.length; ++x) {
            this.controlPoints.add(x, points[x]);
        }
    }

    @Override
    public PointXD[] getCurve(int intervals) {
        if (this.n > 0) {
            PointXD[] points = new PointXD[intervals + 1];
            this.n = this.controlPoints.size() - 1;
            double t = 0.0;
            for (int current = 0; current <= intervals; ++current) {
                points[current] = this.getPoint(t);
                t += 1.0 / (double)intervals;
            }
            return points;
        }
        return null;
    }

    @Override
    public PointXD getPoint(double t) {
        PointXD result = new PointXD(0.0, 0.0);
        double B = 0.0;
        for (int i = 0; i <= this.n; ++i) {
            B = BernsteinPolynomial.get(this.n, i, t);
            PointXD temp = (PointXD)this.controlPoints.get(i);
            result.add(((PointXD)this.controlPoints.get(i)).scalarMultiply(B));
        }
        return result;
    }

    @Override
    public void setControlPoint(int location, PointXD c) {
        this.controlPoints.add(location, c);
        ++this.n;
    }

    @Override
    public void removeControlPoint(int location) {
        this.controlPoints.remove(location);
        --this.n;
    }
}

