/*
 * Decompiled with CFR 0.152.
 */
package commonSense.math.analysis;

import commonSense.math.FunctionEvaluationException;
import commonSense.math.analysis.UnivariateRealFunction;
import commonSense.math.analysis.UnivariateRealSolver;
import java.io.Serializable;

public abstract class UnivariateRealSolverImpl
implements UnivariateRealSolver,
Serializable {
    static final long serialVersionUID = 1112491292565386596L;
    protected double absoluteAccuracy;
    protected double relativeAccuracy;
    protected double functionValueAccuracy;
    protected int maximalIterationCount;
    protected double defaultAbsoluteAccuracy;
    protected double defaultRelativeAccuracy;
    protected double defaultFunctionValueAccuracy;
    protected int defaultMaximalIterationCount;
    protected boolean resultComputed = false;
    protected double result;
    protected int iterationCount;
    protected UnivariateRealFunction f;

    protected UnivariateRealSolverImpl(UnivariateRealFunction f, int defaultMaximalIterationCount, double defaultAbsoluteAccuracy) {
        if (f == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this.f = f;
        this.defaultAbsoluteAccuracy = defaultAbsoluteAccuracy;
        this.defaultRelativeAccuracy = 1.0E-14;
        this.defaultFunctionValueAccuracy = 1.0E-15;
        this.absoluteAccuracy = defaultAbsoluteAccuracy;
        this.relativeAccuracy = this.defaultRelativeAccuracy;
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy;
        this.defaultMaximalIterationCount = defaultMaximalIterationCount;
        this.maximalIterationCount = defaultMaximalIterationCount;
    }

    @Override
    public double getResult() {
        if (this.resultComputed) {
            return this.result;
        }
        throw new IllegalStateException("No result available");
    }

    @Override
    public int getIterationCount() {
        if (this.resultComputed) {
            return this.iterationCount;
        }
        throw new IllegalStateException("No result available");
    }

    protected final void setResult(double result, int iterationCount) {
        this.result = result;
        this.iterationCount = iterationCount;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.resultComputed = false;
    }

    @Override
    public void setAbsoluteAccuracy(double accuracy) {
        this.absoluteAccuracy = accuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public void resetAbsoluteAccuracy() {
        this.absoluteAccuracy = this.defaultAbsoluteAccuracy;
    }

    @Override
    public void setMaximalIterationCount(int count) {
        this.maximalIterationCount = count;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.maximalIterationCount;
    }

    @Override
    public void resetMaximalIterationCount() {
        this.maximalIterationCount = this.defaultMaximalIterationCount;
    }

    @Override
    public void setRelativeAccuracy(double accuracy) {
        this.relativeAccuracy = accuracy;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public void resetRelativeAccuracy() {
        this.relativeAccuracy = this.defaultRelativeAccuracy;
    }

    @Override
    public void setFunctionValueAccuracy(double accuracy) {
        this.functionValueAccuracy = accuracy;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    @Override
    public void resetFunctionValueAccuracy() {
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy;
    }

    protected boolean isBracketing(double lower, double upper, UnivariateRealFunction f) throws FunctionEvaluationException {
        return f.value(lower) * f.value(upper) < 0.0;
    }

    protected boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    protected void verifyInterval(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("Endpoints do not specify an interval: [" + lower + "," + upper + "]");
        }
    }

    protected void verifySequence(double lower, double initial, double upper) {
        if (!this.isSequence(lower, initial, upper)) {
            throw new IllegalArgumentException("Invalid interval, initial value parameters:  lower=" + lower + " initial=" + initial + " upper=" + upper);
        }
    }

    protected void verifyBracketing(double lower, double upper, UnivariateRealFunction f) throws FunctionEvaluationException {
        this.verifyInterval(lower, upper);
        if (!this.isBracketing(lower, upper, f)) {
            throw new IllegalArgumentException("Function values at endpoints do not have different signs.  Endpoints: [" + lower + "," + upper + "]" + "  Values: [" + f.value(lower) + "," + f.value(upper) + "]");
        }
    }
}

