/*
 * Decompiled with CFR 0.152.
 */
package commonSense.graphs;

import commonSense.graphs.DataSet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;

public class BasicGraph
extends Canvas {
    private static long serialVersionUID = 1L;
    private Vector dataSets = new Vector();
    private int noDataSets = 0;
    private double minXaxis = 0.0;
    private double minYaxis = 0.0;
    private double maxXaxis = 0.0;
    private double maxYaxis = 0.0;
    private boolean flip = false;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public static void setSerialVersionUID(long aSerialVersionUID) {
        serialVersionUID = aSerialVersionUID;
    }

    public BasicGraph() {
        this.setBackground(Color.white);
    }

    public BasicGraph(double[][] data) {
        this();
        this.addDataSet(data);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        double widthMulti = (double)d.width / (this.getMaxXaxis() - this.getMinXaxis()) * 0.9;
        double heightMulti = (double)d.height / (this.getMaxYaxis() - this.getMinYaxis()) * 0.9;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        g.drawLine(25, 0, 25, d.height - 25);
        g.drawLine(25, d.height - 25, d.width - 1, d.height - 25);
        int xStep = (d.width - 25) / 10;
        for (int x = 0; x < 10; ++x) {
            g.drawLine(22, xStep * x, 25, xStep * x);
        }
        double[][] data = null;
        int xx = 0;
        int yy = 0;
        for (int x = 0; x < this.getNoDataSets(); ++x) {
            DataSet ds = (DataSet)this.getDataSets().get(x);
            data = ds.getData();
            int points = ds.getRowDimension();
            g.setColor(ds.getFillColor());
            for (int y = 0; y < points; ++y) {
                xx = (int)((data[y][0] - this.getMinXaxis() / 0.9) * widthMulti - 4.0);
                yy = (int)(this.isFlip() ? (data[y][1] - this.getMinYaxis() / 0.9) * heightMulti - 4.0 : (double)d.height - (data[y][1] - this.getMinYaxis() / 0.9) * heightMulti - 4.0);
                g.fillOval(xx, yy, 8, 8);
            }
        }
    }

    public void addDataSet(double[][] data) {
        this.addDataSet(data, Color.BLACK);
    }

    public void addDataSet(double[][] data, Color fill) {
        DataSet ds = new DataSet(data);
        ds.setFillColor(fill);
        this.addDataSet(ds);
    }

    public void addDataSet(DataSet data) {
        this.setNoDataSets(this.getNoDataSets() + 1);
        this.getDataSets().add(this.getNoDataSets() - 1, data);
        if (this.getMinXaxis() > data.minX) {
            this.setMinXaxis(data.minX);
        }
        if (this.getMinYaxis() > data.minY) {
            this.setMinYaxis(data.minY);
        }
        if (this.getMaxXaxis() < data.maxX) {
            this.setMaxXaxis(data.maxX);
        }
        if (this.getMaxYaxis() < data.maxY) {
            this.setMaxYaxis(data.maxY);
        }
        this.repaint();
    }

    public void flipData(boolean flipData) {
        this.setFlip(flipData);
    }

    public void reset() {
        this.getDataSets().clear();
        this.setNoDataSets(0);
        this.setMinXaxis(0.0);
        this.setMinYaxis(0.0);
        this.setMaxXaxis(0.0);
        this.setMaxYaxis(0.0);
    }

    public Vector getDataSets() {
        return this.dataSets;
    }

    public int getNoDataSets() {
        return this.noDataSets;
    }

    public double getMinXaxis() {
        return this.minXaxis;
    }

    public double getMinYaxis() {
        return this.minYaxis;
    }

    public double getMaxXaxis() {
        return this.maxXaxis;
    }

    public double getMaxYaxis() {
        return this.maxYaxis;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public void setDataSets(Vector dataSets) {
        this.dataSets = dataSets;
    }

    public void setNoDataSets(int noDataSets) {
        this.noDataSets = noDataSets;
    }

    public void setMinXaxis(double minXaxis) {
        this.minXaxis = minXaxis;
    }

    public void setMinYaxis(double minYaxis) {
        this.minYaxis = minYaxis;
    }

    public void setMaxXaxis(double maxXaxis) {
        this.maxXaxis = maxXaxis;
    }

    public void setMaxYaxis(double maxYaxis) {
        this.maxYaxis = maxYaxis;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }

    public static void main(String[] args) {
        double[][] data = new double[][]{{100.0, 100.0}, {200.0, 30.0}, {34.0, 67.0}, {134.0, 87.0}};
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add(new BasicGraph(data));
        f.setSize(500, 500);
        f.validate();
        f.setVisible(true);
    }
}

