/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import com.sun.medialib.codec.png.Encoder;
import com.sun.medialib.codec.png.PNGChunk;
import com.sun.medialib.codec.png.PNGTextualData;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.w3c.dom.Node;

public class CLibPNGMetadata
extends IIOMetadata
implements Cloneable {
    public static final String nativeMetadataFormatName = "javax_imageio_png_1.0";
    protected static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat";
    public static final String[] IHDR_colorTypeNames;
    public static final int[] IHDR_numChannels;
    public static final String[] IHDR_bitDepths;
    public static final String[] IHDR_compressionMethodNames;
    public static final String[] IHDR_filterMethodNames;
    public static final String[] IHDR_interlaceMethodNames;
    public static final String[] iCCP_compressionMethodNames;
    public static final String[] zTXt_compressionMethodNames;
    public static final int PHYS_UNIT_UNKNOWN = 0;
    public static final int PHYS_UNIT_METER = 1;
    public static final String[] unitSpecifierNames;
    public static final String[] renderingIntentNames;
    public static final String[] colorSpaceTypeNames;
    static final int IHDR_TYPE;
    static final int PLTE_TYPE;
    static final int IDAT_TYPE;
    static final int IEND_TYPE;
    static final int bKGD_TYPE;
    static final int cHRM_TYPE;
    static final int gAMA_TYPE;
    static final int hIST_TYPE;
    static final int iCCP_TYPE;
    static final int iTXt_TYPE;
    static final int pHYs_TYPE;
    static final int sBIT_TYPE;
    static final int sPLT_TYPE;
    static final int sRGB_TYPE;
    static final int tEXt_TYPE;
    static final int tIME_TYPE;
    static final int tRNS_TYPE;
    static final int zTXt_TYPE;
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    public boolean IHDR_present;
    public int IHDR_width;
    public int IHDR_height;
    public int IHDR_bitDepth;
    public int IHDR_colorType;
    public int IHDR_compressionMethod;
    public int IHDR_filterMethod;
    public int IHDR_interlaceMethod;
    public boolean PLTE_present;
    public byte[] PLTE_red;
    public byte[] PLTE_green;
    public byte[] PLTE_blue;
    public boolean bKGD_present;
    public int bKGD_colorType;
    public int bKGD_index;
    public int bKGD_gray;
    public int bKGD_red;
    public int bKGD_green;
    public int bKGD_blue;
    public boolean cHRM_present;
    public int cHRM_whitePointX;
    public int cHRM_whitePointY;
    public int cHRM_redX;
    public int cHRM_redY;
    public int cHRM_greenX;
    public int cHRM_greenY;
    public int cHRM_blueX;
    public int cHRM_blueY;
    public boolean gAMA_present;
    public int gAMA_gamma;
    public boolean hIST_present;
    public char[] hIST_histogram;
    public boolean iCCP_present;
    public String iCCP_profileName;
    public int iCCP_compressionMethod;
    public byte[] iCCP_compressedProfile;
    public ArrayList iTXt_keyword = new ArrayList();
    public ArrayList iTXt_compressionFlag = new ArrayList();
    public ArrayList iTXt_compressionMethod = new ArrayList();
    public ArrayList iTXt_languageTag = new ArrayList();
    public ArrayList iTXt_translatedKeyword = new ArrayList();
    public ArrayList iTXt_text = new ArrayList();
    public boolean pHYs_present;
    public int pHYs_pixelsPerUnitXAxis;
    public int pHYs_pixelsPerUnitYAxis;
    public int pHYs_unitSpecifier;
    public boolean sBIT_present;
    public int sBIT_colorType;
    public int sBIT_grayBits;
    public int sBIT_redBits;
    public int sBIT_greenBits;
    public int sBIT_blueBits;
    public int sBIT_alphaBits;
    public boolean sPLT_present;
    public String sPLT_paletteName;
    public int sPLT_sampleDepth;
    public int[] sPLT_red;
    public int[] sPLT_green;
    public int[] sPLT_blue;
    public int[] sPLT_alpha;
    public int[] sPLT_frequency;
    public boolean sRGB_present;
    public int sRGB_renderingIntent;
    public ArrayList tEXt_keyword = new ArrayList();
    public ArrayList tEXt_text = new ArrayList();
    public boolean tIME_present;
    public int tIME_year;
    public int tIME_month;
    public int tIME_day;
    public int tIME_hour;
    public int tIME_minute;
    public int tIME_second;
    public boolean tRNS_present;
    public int tRNS_colorType;
    public byte[] tRNS_alpha;
    public int tRNS_gray;
    public int tRNS_red;
    public int tRNS_green;
    public int tRNS_blue;
    public ArrayList zTXt_keyword = new ArrayList();
    public ArrayList zTXt_compressionMethod = new ArrayList();
    public ArrayList zTXt_text = new ArrayList();
    public ArrayList unknownChunkType = new ArrayList();
    public ArrayList unknownChunkData = new ArrayList();
    private boolean gotHeader = false;
    private boolean gotMetadata = false;
    private Decoder decoder = null;
    private CLibPNGImageReader reader = null;

    public CLibPNGMetadata() {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public CLibPNGMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        this();
        if (metadata != null) {
            List<String> formats = Arrays.asList(metadata.getMetadataFormatNames());
            if (formats.contains(nativeMetadataFormatName)) {
                String format = nativeMetadataFormatName;
                this.setFromTree(format, metadata.getAsTree(format));
            } else if (metadata.isStandardMetadataFormatSupported()) {
                String format = "javax_imageio_1.0";
                this.setFromTree(format, metadata.getAsTree(format));
            }
        }
    }

    public void initialize(ImageTypeSpecifier imageType, int numBands, ImageWriteParam param, int interlaceMethod) {
        ColorModel colorModel = imageType.getColorModel();
        SampleModel sampleModel = imageType.getSampleModel();
        this.IHDR_width = sampleModel.getWidth();
        this.IHDR_height = sampleModel.getHeight();
        int[] sampleSize = sampleModel.getSampleSize();
        int bitDepth = sampleSize[0];
        int i = 1;
        while (i < sampleSize.length) {
            if (sampleSize[i] > bitDepth) {
                bitDepth = sampleSize[i];
            }
            ++i;
        }
        if (sampleSize.length > 1 && bitDepth < 8) {
            bitDepth = 8;
        }
        if (bitDepth > 2 && bitDepth < 4) {
            bitDepth = 4;
        } else if (bitDepth > 4 && bitDepth < 8) {
            bitDepth = 8;
        } else if (bitDepth > 8 && bitDepth < 16) {
            bitDepth = 16;
        } else if (bitDepth > 16) {
            throw new RuntimeException("bitDepth > 16!");
        }
        this.IHDR_bitDepth = bitDepth;
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int size = icm.getMapSize();
            byte[] reds = new byte[size];
            icm.getReds(reds);
            byte[] greens = new byte[size];
            icm.getGreens(greens);
            byte[] blues = new byte[size];
            icm.getBlues(blues);
            boolean isGray = false;
            if (!this.IHDR_present || this.IHDR_colorType != 3) {
                isGray = true;
                int scale = 255 / ((1 << this.IHDR_bitDepth) - 1);
                int i2 = 0;
                while (i2 < size) {
                    byte red = reds[i2];
                    if (red != (byte)(i2 * scale) || red != greens[i2] || red != blues[i2]) {
                        isGray = false;
                        break;
                    }
                    ++i2;
                }
            }
            boolean hasAlpha = colorModel.hasAlpha();
            byte[] alpha = null;
            if (hasAlpha) {
                alpha = new byte[size];
                icm.getAlphas(alpha);
            }
            if (isGray && hasAlpha) {
                this.IHDR_colorType = 4;
            } else if (isGray) {
                this.IHDR_colorType = 0;
            } else {
                this.IHDR_colorType = 3;
                this.PLTE_present = true;
                this.PLTE_red = (byte[])reds.clone();
                this.PLTE_green = (byte[])greens.clone();
                this.PLTE_blue = (byte[])blues.clone();
                if (hasAlpha) {
                    this.tRNS_present = true;
                    this.tRNS_colorType = 3;
                    this.tRNS_alpha = (byte[])alpha.clone();
                }
            }
        } else if (numBands == 1) {
            this.IHDR_colorType = 0;
        } else if (numBands == 2) {
            this.IHDR_colorType = 4;
        } else if (numBands == 3) {
            this.IHDR_colorType = 2;
        } else if (numBands == 4) {
            this.IHDR_colorType = 6;
        } else {
            throw new RuntimeException("Number of bands not 1-4!");
        }
        this.IHDR_filterMethod = 0;
        this.IHDR_compressionMethod = 0;
        this.IHDR_interlaceMethod = param != null && param.getProgressiveMode() == 0 ? 0 : (param != null && param.getProgressiveMode() == 1 ? 1 : interlaceMethod);
        this.IHDR_present = true;
    }

    public boolean isReadOnly() {
        return false;
    }

    private ArrayList cloneBytesArrayList(ArrayList in) {
        if (in == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(in.size());
        Iterator iter = in.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                list.add(null);
                continue;
            }
            list.add(((byte[])o).clone());
        }
        return list;
    }

    public Object clone() {
        CLibPNGMetadata metadata;
        try {
            metadata = (CLibPNGMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        metadata.unknownChunkData = this.cloneBytesArrayList(this.unknownChunkData);
        return metadata;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode entry;
        IIOMetadataNode node = null;
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.IHDR_present) {
            IIOMetadataNode IHDR_node = new IIOMetadataNode("IHDR");
            IHDR_node.setAttribute("width", Integer.toString(this.IHDR_width));
            IHDR_node.setAttribute("height", Integer.toString(this.IHDR_height));
            IHDR_node.setAttribute("bitDepth", Integer.toString(this.IHDR_bitDepth));
            IHDR_node.setAttribute("colorType", IHDR_colorTypeNames[this.IHDR_colorType]);
            IHDR_node.setAttribute("compressionMethod", IHDR_compressionMethodNames[this.IHDR_compressionMethod]);
            IHDR_node.setAttribute("filterMethod", IHDR_filterMethodNames[this.IHDR_filterMethod]);
            IHDR_node.setAttribute("interlaceMethod", IHDR_interlaceMethodNames[this.IHDR_interlaceMethod]);
            root.appendChild(IHDR_node);
        }
        if (this.PLTE_present) {
            IIOMetadataNode PLTE_node = new IIOMetadataNode("PLTE");
            int numEntries = this.PLTE_red.length;
            int i = 0;
            while (i < numEntries) {
                entry = new IIOMetadataNode("PLTEEntry");
                entry.setAttribute("index", Integer.toString(i));
                entry.setAttribute("red", Integer.toString(this.PLTE_red[i] & 0xFF));
                entry.setAttribute("green", Integer.toString(this.PLTE_green[i] & 0xFF));
                entry.setAttribute("blue", Integer.toString(this.PLTE_blue[i] & 0xFF));
                PLTE_node.appendChild(entry);
                ++i;
            }
            root.appendChild(PLTE_node);
        }
        if (this.bKGD_present) {
            IIOMetadataNode bKGD_node = new IIOMetadataNode("bKGD");
            if (this.bKGD_colorType == 3) {
                node = new IIOMetadataNode("bKGD_Palette");
                node.setAttribute("index", Integer.toString(this.bKGD_index));
            } else if (this.bKGD_colorType == 0) {
                node = new IIOMetadataNode("bKGD_Grayscale");
                node.setAttribute("gray", Integer.toString(this.bKGD_gray));
            } else if (this.bKGD_colorType == 2) {
                node = new IIOMetadataNode("bKGD_RGB");
                node.setAttribute("red", Integer.toString(this.bKGD_red));
                node.setAttribute("green", Integer.toString(this.bKGD_green));
                node.setAttribute("blue", Integer.toString(this.bKGD_blue));
            }
            bKGD_node.appendChild(node);
            root.appendChild(bKGD_node);
        }
        if (this.cHRM_present) {
            IIOMetadataNode cHRM_node = new IIOMetadataNode("cHRM");
            cHRM_node.setAttribute("whitePointX", Integer.toString(this.cHRM_whitePointX));
            cHRM_node.setAttribute("whitePointY", Integer.toString(this.cHRM_whitePointY));
            cHRM_node.setAttribute("redX", Integer.toString(this.cHRM_redX));
            cHRM_node.setAttribute("redY", Integer.toString(this.cHRM_redY));
            cHRM_node.setAttribute("greenX", Integer.toString(this.cHRM_greenX));
            cHRM_node.setAttribute("greenY", Integer.toString(this.cHRM_greenY));
            cHRM_node.setAttribute("blueX", Integer.toString(this.cHRM_blueX));
            cHRM_node.setAttribute("blueY", Integer.toString(this.cHRM_blueY));
            root.appendChild(cHRM_node);
        }
        if (this.gAMA_present) {
            IIOMetadataNode gAMA_node = new IIOMetadataNode("gAMA");
            gAMA_node.setAttribute("value", Integer.toString(this.gAMA_gamma));
            root.appendChild(gAMA_node);
        }
        if (this.hIST_present) {
            IIOMetadataNode hIST_node = new IIOMetadataNode("hIST");
            int i = 0;
            while (i < this.hIST_histogram.length) {
                IIOMetadataNode hist = new IIOMetadataNode("hISTEntry");
                hist.setAttribute("index", Integer.toString(i));
                hist.setAttribute("value", Integer.toString(this.hIST_histogram[i]));
                hIST_node.appendChild(hist);
                ++i;
            }
            root.appendChild(hIST_node);
        }
        if (this.iCCP_present) {
            IIOMetadataNode iCCP_node = new IIOMetadataNode("iCCP");
            iCCP_node.setAttribute("profileName", this.iCCP_profileName);
            iCCP_node.setAttribute("compressionMethod", iCCP_compressionMethodNames[this.iCCP_compressionMethod]);
            Object profile = this.iCCP_compressedProfile;
            if (profile != null) {
                profile = profile.clone();
            }
            iCCP_node.setUserObject(profile);
            root.appendChild(iCCP_node);
        }
        if (this.iTXt_keyword.size() > 0) {
            IIOMetadataNode iTXt_parent = new IIOMetadataNode("iTXt");
            int i = 0;
            while (i < this.iTXt_keyword.size()) {
                IIOMetadataNode iTXt_node = new IIOMetadataNode("iTXtEntry");
                iTXt_node.setAttribute("keyword", (String)this.iTXt_keyword.get(i));
                Integer val = (Integer)this.iTXt_compressionFlag.get(i);
                iTXt_node.setAttribute("compressionFlag", val.toString());
                val = (Integer)this.iTXt_compressionMethod.get(i);
                iTXt_node.setAttribute("compressionMethod", val.toString());
                iTXt_node.setAttribute("languageTag", (String)this.iTXt_languageTag.get(i));
                iTXt_node.setAttribute("translatedKeyword", (String)this.iTXt_translatedKeyword.get(i));
                iTXt_node.setAttribute("text", (String)this.iTXt_text.get(i));
                iTXt_parent.appendChild(iTXt_node);
                ++i;
            }
            root.appendChild(iTXt_parent);
        }
        if (this.pHYs_present) {
            IIOMetadataNode pHYs_node = new IIOMetadataNode("pHYs");
            pHYs_node.setAttribute("pixelsPerUnitXAxis", Integer.toString(this.pHYs_pixelsPerUnitXAxis));
            pHYs_node.setAttribute("pixelsPerUnitYAxis", Integer.toString(this.pHYs_pixelsPerUnitYAxis));
            pHYs_node.setAttribute("unitSpecifier", unitSpecifierNames[this.pHYs_unitSpecifier]);
            root.appendChild(pHYs_node);
        }
        if (this.sBIT_present) {
            IIOMetadataNode sBIT_node = new IIOMetadataNode("sBIT");
            if (this.sBIT_colorType == 0) {
                node = new IIOMetadataNode("sBIT_Grayscale");
                node.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
            } else if (this.sBIT_colorType == 4) {
                node = new IIOMetadataNode("sBIT_GrayAlpha");
                node.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
                node.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 2) {
                node = new IIOMetadataNode("sBIT_RGB");
                node.setAttribute("red", Integer.toString(this.sBIT_redBits));
                node.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                node.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            } else if (this.sBIT_colorType == 6) {
                node = new IIOMetadataNode("sBIT_RGBAlpha");
                node.setAttribute("red", Integer.toString(this.sBIT_redBits));
                node.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                node.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
                node.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 3) {
                node = new IIOMetadataNode("sBIT_Palette");
                node.setAttribute("red", Integer.toString(this.sBIT_redBits));
                node.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                node.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            }
            sBIT_node.appendChild(node);
            root.appendChild(sBIT_node);
        }
        if (this.sPLT_present) {
            IIOMetadataNode sPLT_node = new IIOMetadataNode("sPLT");
            sPLT_node.setAttribute("name", this.sPLT_paletteName);
            sPLT_node.setAttribute("sampleDepth", Integer.toString(this.sPLT_sampleDepth));
            int numEntries = this.sPLT_red.length;
            int i = 0;
            while (i < numEntries) {
                entry = new IIOMetadataNode("sPLTEntry");
                entry.setAttribute("index", Integer.toString(i));
                entry.setAttribute("red", Integer.toString(this.sPLT_red[i]));
                entry.setAttribute("green", Integer.toString(this.sPLT_green[i]));
                entry.setAttribute("blue", Integer.toString(this.sPLT_blue[i]));
                entry.setAttribute("alpha", Integer.toString(this.sPLT_alpha[i]));
                entry.setAttribute("frequency", Integer.toString(this.sPLT_frequency[i]));
                sPLT_node.appendChild(entry);
                ++i;
            }
            root.appendChild(sPLT_node);
        }
        if (this.sRGB_present) {
            IIOMetadataNode sRGB_node = new IIOMetadataNode("sRGB");
            sRGB_node.setAttribute("renderingIntent", renderingIntentNames[this.sRGB_renderingIntent]);
            root.appendChild(sRGB_node);
        }
        if (this.tEXt_keyword.size() > 0) {
            IIOMetadataNode tEXt_parent = new IIOMetadataNode("tEXt");
            int i = 0;
            while (i < this.tEXt_keyword.size()) {
                IIOMetadataNode tEXt_node = new IIOMetadataNode("tEXtEntry");
                tEXt_node.setAttribute("keyword", (String)this.tEXt_keyword.get(i));
                tEXt_node.setAttribute("value", (String)this.tEXt_text.get(i));
                tEXt_parent.appendChild(tEXt_node);
                ++i;
            }
            root.appendChild(tEXt_parent);
        }
        if (this.tIME_present) {
            IIOMetadataNode tIME_node = new IIOMetadataNode("tIME");
            tIME_node.setAttribute("year", Integer.toString(this.tIME_year));
            tIME_node.setAttribute("month", Integer.toString(this.tIME_month));
            tIME_node.setAttribute("day", Integer.toString(this.tIME_day));
            tIME_node.setAttribute("hour", Integer.toString(this.tIME_hour));
            tIME_node.setAttribute("minute", Integer.toString(this.tIME_minute));
            tIME_node.setAttribute("second", Integer.toString(this.tIME_second));
            root.appendChild(tIME_node);
        }
        if (this.tRNS_present) {
            IIOMetadataNode tRNS_node = new IIOMetadataNode("tRNS");
            if (this.tRNS_colorType == 3) {
                node = new IIOMetadataNode("tRNS_Palette");
                int i = 0;
                while (i < this.tRNS_alpha.length) {
                    IIOMetadataNode entry2 = new IIOMetadataNode("tRNS_PaletteEntry");
                    entry2.setAttribute("index", Integer.toString(i));
                    entry2.setAttribute("alpha", Integer.toString(this.tRNS_alpha[i] & 0xFF));
                    node.appendChild(entry2);
                    ++i;
                }
            } else if (this.tRNS_colorType == 0) {
                node = new IIOMetadataNode("tRNS_Grayscale");
                node.setAttribute("gray", Integer.toString(this.tRNS_gray));
            } else if (this.tRNS_colorType == 2) {
                node = new IIOMetadataNode("tRNS_RGB");
                node.setAttribute("red", Integer.toString(this.tRNS_red));
                node.setAttribute("green", Integer.toString(this.tRNS_green));
                node.setAttribute("blue", Integer.toString(this.tRNS_blue));
            }
            tRNS_node.appendChild(node);
            root.appendChild(tRNS_node);
        }
        if (this.zTXt_keyword.size() > 0) {
            IIOMetadataNode zTXt_parent = new IIOMetadataNode("zTXt");
            int i = 0;
            while (i < this.zTXt_keyword.size()) {
                IIOMetadataNode zTXt_node = new IIOMetadataNode("zTXtEntry");
                zTXt_node.setAttribute("keyword", (String)this.zTXt_keyword.get(i));
                int cm = (Integer)this.zTXt_compressionMethod.get(i);
                zTXt_node.setAttribute("compressionMethod", zTXt_compressionMethodNames[cm]);
                zTXt_node.setAttribute("text", (String)this.zTXt_text.get(i));
                zTXt_parent.appendChild(zTXt_node);
                ++i;
            }
            root.appendChild(zTXt_parent);
        }
        if (this.unknownChunkType.size() > 0) {
            IIOMetadataNode unknown_parent = new IIOMetadataNode("UnknownChunks");
            int i = 0;
            while (i < this.unknownChunkType.size()) {
                IIOMetadataNode unknown_node = new IIOMetadataNode("UnknownChunk");
                unknown_node.setAttribute("type", (String)this.unknownChunkType.get(i));
                unknown_node.setUserObject((byte[])this.unknownChunkData.get(i));
                unknown_parent.appendChild(unknown_node);
                ++i;
            }
            root.appendChild(unknown_parent);
        }
        return root;
    }

    private int getNumChannels() {
        int numChannels = IHDR_numChannels[this.IHDR_colorType];
        if (this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType) {
            numChannels = 4;
        }
        return numChannels;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ColorSpaceType");
        node.setAttribute("name", colorSpaceTypeNames[this.IHDR_colorType]);
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("NumChannels");
        node.setAttribute("value", Integer.toString(this.getNumChannels()));
        chroma_node.appendChild(node);
        if (this.gAMA_present) {
            node = new IIOMetadataNode("Gamma");
            node.setAttribute("value", Float.toString((float)this.gAMA_gamma * 1.0E-5f));
            chroma_node.appendChild(node);
        }
        node = new IIOMetadataNode("BlackIsZero");
        node.setAttribute("value", "TRUE");
        chroma_node.appendChild(node);
        if (this.PLTE_present) {
            boolean hasAlpha = this.tRNS_present && this.tRNS_colorType == 3;
            node = new IIOMetadataNode("Palette");
            int i = 0;
            while (i < this.PLTE_red.length) {
                IIOMetadataNode entry = new IIOMetadataNode("PaletteEntry");
                entry.setAttribute("index", Integer.toString(i));
                entry.setAttribute("red", Integer.toString(this.PLTE_red[i] & 0xFF));
                entry.setAttribute("green", Integer.toString(this.PLTE_green[i] & 0xFF));
                entry.setAttribute("blue", Integer.toString(this.PLTE_blue[i] & 0xFF));
                if (hasAlpha) {
                    int alpha = i < this.tRNS_alpha.length ? this.tRNS_alpha[i] & 0xFF : 255;
                    entry.setAttribute("alpha", Integer.toString(alpha));
                }
                node.appendChild(entry);
                ++i;
            }
            chroma_node.appendChild(node);
        }
        if (this.bKGD_present) {
            if (this.bKGD_colorType == 3) {
                node = new IIOMetadataNode("BackgroundIndex");
                node.setAttribute("value", Integer.toString(this.bKGD_index));
            } else {
                int r;
                int g;
                int b;
                node = new IIOMetadataNode("BackgroundColor");
                if (this.bKGD_colorType == 0) {
                    g = b = this.bKGD_gray;
                    r = b;
                } else {
                    r = this.bKGD_red;
                    g = this.bKGD_green;
                    b = this.bKGD_blue;
                }
                node.setAttribute("red", Integer.toString(r));
                node.setAttribute("green", Integer.toString(g));
                node.setAttribute("blue", Integer.toString(b));
            }
            chroma_node.appendChild(node);
        }
        return chroma_node;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("CompressionTypeName");
        node.setAttribute("value", "deflate");
        compression_node.appendChild(node);
        node = new IIOMetadataNode("Lossless");
        node.setAttribute("value", "TRUE");
        compression_node.appendChild(node);
        node = new IIOMetadataNode("NumProgressiveScans");
        node.setAttribute("value", this.IHDR_interlaceMethod == 0 ? "1" : "7");
        compression_node.appendChild(node);
        return compression_node;
    }

    private String repeat(String s, int times) {
        if (times == 1) {
            return s;
        }
        StringBuffer sb = new StringBuffer((s.length() + 1) * times - 1);
        sb.append(s);
        int i = 1;
        while (i < times) {
            sb.append(" ");
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("PlanarConfiguration");
        node.setAttribute("value", "PixelInterleaved");
        data_node.appendChild(node);
        node = new IIOMetadataNode("SampleFormat");
        node.setAttribute("value", this.IHDR_colorType == 3 ? "Index" : "UnsignedIntegral");
        data_node.appendChild(node);
        String bitDepth = Integer.toString(this.IHDR_bitDepth);
        node = new IIOMetadataNode("BitsPerSample");
        node.setAttribute("value", this.repeat(bitDepth, this.getNumChannels()));
        data_node.appendChild(node);
        if (this.sBIT_present) {
            node = new IIOMetadataNode("SignificantBitsPerSample");
            String sbits = this.sBIT_colorType == 0 || this.sBIT_colorType == 4 ? Integer.toString(this.sBIT_grayBits) : Integer.toString(this.sBIT_redBits) + " " + Integer.toString(this.sBIT_greenBits) + " " + Integer.toString(this.sBIT_blueBits);
            if (this.sBIT_colorType == 4 || this.sBIT_colorType == 6) {
                sbits = sbits + " " + Integer.toString(this.sBIT_alphaBits);
            }
            node.setAttribute("value", sbits);
            data_node.appendChild(node);
        }
        return data_node;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("PixelAspectRatio");
        float ratio = this.pHYs_present ? (float)this.pHYs_pixelsPerUnitYAxis / (float)this.pHYs_pixelsPerUnitXAxis : 1.0f;
        node.setAttribute("value", Float.toString(ratio));
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("ImageOrientation");
        node.setAttribute("value", "Normal");
        dimension_node.appendChild(node);
        if (this.pHYs_present && this.pHYs_unitSpecifier == 1) {
            node = new IIOMetadataNode("HorizontalPixelSize");
            node.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitXAxis));
            dimension_node.appendChild(node);
            node = new IIOMetadataNode("VerticalPixelSize");
            node.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitYAxis));
            dimension_node.appendChild(node);
        }
        return dimension_node;
    }

    public IIOMetadataNode getStandardDocumentNode() {
        if (!this.tIME_present) {
            return null;
        }
        IIOMetadataNode document_node = new IIOMetadataNode("Document");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ImageModificationTime");
        node.setAttribute("year", Integer.toString(this.tIME_year));
        node.setAttribute("month", Integer.toString(this.tIME_month));
        node.setAttribute("day", Integer.toString(this.tIME_day));
        node.setAttribute("hour", Integer.toString(this.tIME_hour));
        node.setAttribute("minute", Integer.toString(this.tIME_minute));
        node.setAttribute("second", Integer.toString(this.tIME_second));
        document_node.appendChild(node);
        return document_node;
    }

    public IIOMetadataNode getStandardTextNode() {
        int numEntries = this.tEXt_keyword.size() + this.iTXt_keyword.size() + this.zTXt_keyword.size();
        if (numEntries == 0) {
            return null;
        }
        IIOMetadataNode text_node = new IIOMetadataNode("Text");
        IIOMetadataNode node = null;
        int i = 0;
        while (i < this.tEXt_keyword.size()) {
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", (String)this.tEXt_keyword.get(i));
            node.setAttribute("value", (String)this.tEXt_text.get(i));
            node.setAttribute("encoding", "ISO-8859-1");
            node.setAttribute("compression", "none");
            text_node.appendChild(node);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.iTXt_keyword.size()) {
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", (String)this.iTXt_keyword.get(i2));
            node.setAttribute("value", (String)this.iTXt_text.get(i2));
            node.setAttribute("language", (String)this.iTXt_languageTag.get(i2));
            if ((Integer)this.iTXt_compressionFlag.get(i2) == 1) {
                node.setAttribute("compression", "deflate");
            } else {
                node.setAttribute("compression", "none");
            }
            text_node.appendChild(node);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.zTXt_keyword.size()) {
            node = new IIOMetadataNode("TextEntry");
            node.setAttribute("keyword", (String)this.zTXt_keyword.get(i3));
            node.setAttribute("value", (String)this.zTXt_text.get(i3));
            node.setAttribute("compression", "deflate");
            text_node.appendChild(node);
            ++i3;
        }
        return text_node;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode transparency_node = new IIOMetadataNode("Transparency");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("Alpha");
        boolean hasAlpha = this.IHDR_colorType == 6 || this.IHDR_colorType == 4 || this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType && this.tRNS_alpha != null;
        node.setAttribute("value", hasAlpha ? "nonpremultiplied" : "none");
        transparency_node.appendChild(node);
        if (this.tRNS_present && (this.tRNS_colorType == 2 || this.tRNS_colorType == 0)) {
            node = new IIOMetadataNode("TransparentColor");
            if (this.tRNS_colorType == 2) {
                node.setAttribute("value", Integer.toString(this.tRNS_red) + " " + Integer.toString(this.tRNS_green) + " " + Integer.toString(this.tRNS_blue));
            } else if (this.tRNS_colorType == 0) {
                node.setAttribute("value", Integer.toString(this.tRNS_gray));
            }
            transparency_node.appendChild(node);
        }
        return transparency_node;
    }

    private void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }

    private int getIntAttribute(Node node, String name, int defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private float getFloatAttribute(Node node, String name, float defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    private int getIntAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, name, -1, true);
    }

    private float getFloatAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getFloatAttribute(node, name, -1.0f, true);
    }

    private boolean getBooleanAttribute(Node node, String name, boolean defaultValue, boolean required) throws IIOInvalidTreeException {
        String value;
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        if ((value = attr.getNodeValue()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        this.fatal(node, "Attribute " + name + " must be 'true' or 'false'!");
        return false;
    }

    private boolean getBooleanAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getBooleanAttribute(node, name, false, true);
    }

    private int getEnumeratedAttribute(Node node, String name, String[] legalNames, int defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        String value = attr.getNodeValue();
        int i = 0;
        while (i < legalNames.length) {
            if (value.equals(legalNames[i])) {
                return i;
            }
            ++i;
        }
        this.fatal(node, "Illegal value for attribute " + name + "!");
        return -1;
    }

    private int getEnumeratedAttribute(Node node, String name, String[] legalNames) throws IIOInvalidTreeException {
        return this.getEnumeratedAttribute(node, name, legalNames, -1, true);
    }

    private String getAttribute(Node node, String name, String defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        return attr.getNodeValue();
    }

    private String getAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getAttribute(node, name, null, true);
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node, "Root must be javax_imageio_png_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            Object[] red;
            String name = node.getNodeName();
            if (name.equals("IHDR")) {
                this.IHDR_width = this.getIntAttribute(node, "width");
                this.IHDR_height = this.getIntAttribute(node, "height");
                this.IHDR_bitDepth = this.getEnumeratedAttribute(node, "bitDepth", IHDR_bitDepths);
                this.IHDR_colorType = this.getEnumeratedAttribute(node, "colorType", IHDR_colorTypeNames);
                this.IHDR_compressionMethod = this.getEnumeratedAttribute(node, "compressionMethod", IHDR_compressionMethodNames);
                this.IHDR_filterMethod = this.getEnumeratedAttribute(node, "filterMethod", IHDR_filterMethodNames);
                this.IHDR_interlaceMethod = this.getEnumeratedAttribute(node, "interlaceMethod", IHDR_interlaceMethodNames);
                this.IHDR_present = true;
            } else if (name.equals("PLTE")) {
                red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                int maxindex = -1;
                Node PLTE_entry = node.getFirstChild();
                if (PLTE_entry == null) {
                    this.fatal(node, "Palette has no entries!");
                }
                while (PLTE_entry != null) {
                    int index;
                    if (!PLTE_entry.getNodeName().equals("PLTEEntry")) {
                        this.fatal(node, "Only a PLTEEntry may be a child of a PLTE!");
                    }
                    if ((index = this.getIntAttribute(PLTE_entry, "index")) < 0 || index > 255) {
                        this.fatal(node, "Bad value for PLTEEntry attribute index!");
                    }
                    if (index > maxindex) {
                        maxindex = index;
                    }
                    red[index] = (byte)this.getIntAttribute(PLTE_entry, "red");
                    green[index] = (byte)this.getIntAttribute(PLTE_entry, "green");
                    blue[index] = (byte)this.getIntAttribute(PLTE_entry, "blue");
                    PLTE_entry = PLTE_entry.getNextSibling();
                }
                int numEntries = maxindex + 1;
                this.PLTE_red = new byte[numEntries];
                this.PLTE_green = new byte[numEntries];
                this.PLTE_blue = new byte[numEntries];
                System.arraycopy(red, 0, this.PLTE_red, 0, numEntries);
                System.arraycopy(green, 0, this.PLTE_green, 0, numEntries);
                System.arraycopy(blue, 0, this.PLTE_blue, 0, numEntries);
                this.PLTE_present = true;
            } else if (name.equals("bKGD")) {
                String bKGD_name;
                this.bKGD_present = false;
                Node bKGD_node = node.getFirstChild();
                if (bKGD_node == null) {
                    this.fatal(node, "bKGD node has no children!");
                }
                if ((bKGD_name = bKGD_node.getNodeName()).equals("bKGD_Palette")) {
                    this.bKGD_index = this.getIntAttribute(bKGD_node, "index");
                    this.bKGD_colorType = 3;
                } else if (bKGD_name.equals("bKGD_Grayscale")) {
                    this.bKGD_gray = this.getIntAttribute(bKGD_node, "gray");
                    this.bKGD_colorType = 0;
                } else if (bKGD_name.equals("bKGD_RGB")) {
                    this.bKGD_red = this.getIntAttribute(bKGD_node, "red");
                    this.bKGD_green = this.getIntAttribute(bKGD_node, "green");
                    this.bKGD_blue = this.getIntAttribute(bKGD_node, "blue");
                    this.bKGD_colorType = 2;
                } else {
                    this.fatal(node, "Bad child of a bKGD node!");
                }
                if (bKGD_node.getNextSibling() != null) {
                    this.fatal(node, "bKGD node has more than one child!");
                }
                this.bKGD_present = true;
            } else if (name.equals("cHRM")) {
                this.cHRM_whitePointX = this.getIntAttribute(node, "whitePointX");
                this.cHRM_whitePointY = this.getIntAttribute(node, "whitePointY");
                this.cHRM_redX = this.getIntAttribute(node, "redX");
                this.cHRM_redY = this.getIntAttribute(node, "redY");
                this.cHRM_greenX = this.getIntAttribute(node, "greenX");
                this.cHRM_greenY = this.getIntAttribute(node, "greenY");
                this.cHRM_blueX = this.getIntAttribute(node, "blueX");
                this.cHRM_blueY = this.getIntAttribute(node, "blueY");
                this.cHRM_present = true;
            } else if (name.equals("gAMA")) {
                this.gAMA_gamma = this.getIntAttribute(node, "value");
                this.gAMA_present = true;
            } else if (name.equals("hIST")) {
                char[] hist = new char[256];
                int maxindex = -1;
                Node hIST_entry = node.getFirstChild();
                if (hIST_entry == null) {
                    this.fatal(node, "hIST node has no children!");
                }
                while (hIST_entry != null) {
                    int index;
                    if (!hIST_entry.getNodeName().equals("hISTEntry")) {
                        this.fatal(node, "Only a hISTEntry may be a child of a hIST!");
                    }
                    if ((index = this.getIntAttribute(hIST_entry, "index")) < 0 || index > 255) {
                        this.fatal(node, "Bad value for histEntry attribute index!");
                    }
                    if (index > maxindex) {
                        maxindex = index;
                    }
                    hist[index] = (char)this.getIntAttribute(hIST_entry, "value");
                    hIST_entry = hIST_entry.getNextSibling();
                }
                int numEntries = maxindex + 1;
                this.hIST_histogram = new char[numEntries];
                System.arraycopy(hist, 0, this.hIST_histogram, 0, numEntries);
                this.hIST_present = true;
            } else if (name.equals("iCCP")) {
                this.iCCP_profileName = this.getAttribute(node, "profileName");
                this.iCCP_compressionMethod = this.getEnumeratedAttribute(node, "compressionMethod", iCCP_compressionMethodNames);
                Object compressedProfile = ((IIOMetadataNode)node).getUserObject();
                if (compressedProfile == null) {
                    this.fatal(node, "No ICCP profile present in user object!");
                }
                if (!(compressedProfile instanceof byte[])) {
                    this.fatal(node, "User object not a byte array!");
                }
                this.iCCP_compressedProfile = (byte[])((byte[])compressedProfile).clone();
                this.iCCP_present = true;
            } else if (name.equals("iTXt")) {
                Node iTXt_node = node.getFirstChild();
                while (iTXt_node != null) {
                    if (!iTXt_node.getNodeName().equals("iTXtEntry")) {
                        this.fatal(node, "Only an iTXtEntry may be a child of an iTXt!");
                    }
                    String keyword = this.getAttribute(iTXt_node, "keyword");
                    this.iTXt_keyword.add(keyword);
                    boolean compressionFlag = this.getBooleanAttribute(iTXt_node, "compressionFlag");
                    this.iTXt_compressionFlag.add(new Boolean(compressionFlag));
                    String compressionMethod = this.getAttribute(iTXt_node, "compressionMethod");
                    this.iTXt_compressionMethod.add(compressionMethod);
                    String languageTag = this.getAttribute(iTXt_node, "languageTag");
                    this.iTXt_languageTag.add(languageTag);
                    String translatedKeyword = this.getAttribute(iTXt_node, "translatedKeyword");
                    this.iTXt_translatedKeyword.add(translatedKeyword);
                    String text = this.getAttribute(iTXt_node, "text");
                    this.iTXt_text.add(text);
                    iTXt_node = iTXt_node.getNextSibling();
                }
            } else if (name.equals("pHYs")) {
                this.pHYs_pixelsPerUnitXAxis = this.getIntAttribute(node, "pixelsPerUnitXAxis");
                this.pHYs_pixelsPerUnitYAxis = this.getIntAttribute(node, "pixelsPerUnitYAxis");
                this.pHYs_unitSpecifier = this.getEnumeratedAttribute(node, "unitSpecifier", unitSpecifierNames);
                this.pHYs_present = true;
            } else if (name.equals("sBIT")) {
                String sBIT_name;
                this.sBIT_present = false;
                Node sBIT_node = node.getFirstChild();
                if (sBIT_node == null) {
                    this.fatal(node, "sBIT node has no children!");
                }
                if ((sBIT_name = sBIT_node.getNodeName()).equals("sBIT_Grayscale")) {
                    this.sBIT_grayBits = this.getIntAttribute(sBIT_node, "gray");
                    this.sBIT_colorType = 0;
                } else if (sBIT_name.equals("sBIT_GrayAlpha")) {
                    this.sBIT_grayBits = this.getIntAttribute(sBIT_node, "gray");
                    this.sBIT_alphaBits = this.getIntAttribute(sBIT_node, "alpha");
                    this.sBIT_colorType = 4;
                } else if (sBIT_name.equals("sBIT_RGB")) {
                    this.sBIT_redBits = this.getIntAttribute(sBIT_node, "red");
                    this.sBIT_greenBits = this.getIntAttribute(sBIT_node, "green");
                    this.sBIT_blueBits = this.getIntAttribute(sBIT_node, "blue");
                    this.sBIT_colorType = 2;
                } else if (sBIT_name.equals("sBIT_RGBAlpha")) {
                    this.sBIT_redBits = this.getIntAttribute(sBIT_node, "red");
                    this.sBIT_greenBits = this.getIntAttribute(sBIT_node, "green");
                    this.sBIT_blueBits = this.getIntAttribute(sBIT_node, "blue");
                    this.sBIT_alphaBits = this.getIntAttribute(sBIT_node, "alpha");
                    this.sBIT_colorType = 6;
                } else if (sBIT_name.equals("sBIT_Palette")) {
                    this.sBIT_redBits = this.getIntAttribute(sBIT_node, "red");
                    this.sBIT_greenBits = this.getIntAttribute(sBIT_node, "green");
                    this.sBIT_blueBits = this.getIntAttribute(sBIT_node, "blue");
                    this.sBIT_colorType = 3;
                } else {
                    this.fatal(node, "Bad child of an sBIT node!");
                }
                if (sBIT_node.getNextSibling() != null) {
                    this.fatal(node, "sBIT node has more than one child!");
                }
                this.sBIT_present = true;
            } else if (name.equals("sPLT")) {
                this.sPLT_paletteName = this.getAttribute(node, "name");
                this.sPLT_sampleDepth = this.getIntAttribute(node, "sampleDepth");
                red = new int[256];
                int[] green = new int[256];
                int[] blue = new int[256];
                int[] alpha = new int[256];
                int[] frequency = new int[256];
                int maxindex = -1;
                Node sPLT_entry = node.getFirstChild();
                if (sPLT_entry == null) {
                    this.fatal(node, "sPLT node has no children!");
                }
                while (sPLT_entry != null) {
                    int index;
                    if (!sPLT_entry.getNodeName().equals("sPLTEntry")) {
                        this.fatal(node, "Only an sPLTEntry may be a child of an sPLT!");
                    }
                    if ((index = this.getIntAttribute(sPLT_entry, "index")) < 0 || index > 255) {
                        this.fatal(node, "Bad value for PLTEEntry attribute index!");
                    }
                    if (index > maxindex) {
                        maxindex = index;
                    }
                    red[index] = this.getIntAttribute(sPLT_entry, "red");
                    green[index] = this.getIntAttribute(sPLT_entry, "green");
                    blue[index] = this.getIntAttribute(sPLT_entry, "blue");
                    alpha[index] = this.getIntAttribute(sPLT_entry, "alpha");
                    frequency[index] = this.getIntAttribute(sPLT_entry, "frequency");
                    sPLT_entry = sPLT_entry.getNextSibling();
                }
                int numEntries = maxindex + 1;
                this.sPLT_red = new int[numEntries];
                this.sPLT_green = new int[numEntries];
                this.sPLT_blue = new int[numEntries];
                this.sPLT_alpha = new int[numEntries];
                this.sPLT_frequency = new int[numEntries];
                System.arraycopy(red, 0, this.sPLT_red, 0, numEntries);
                System.arraycopy(green, 0, this.sPLT_green, 0, numEntries);
                System.arraycopy(blue, 0, this.sPLT_blue, 0, numEntries);
                System.arraycopy(alpha, 0, this.sPLT_alpha, 0, numEntries);
                System.arraycopy(frequency, 0, this.sPLT_frequency, 0, numEntries);
                this.sPLT_present = true;
            } else if (name.equals("sRGB")) {
                this.sRGB_renderingIntent = this.getEnumeratedAttribute(node, "renderingIntent", renderingIntentNames);
                this.sRGB_present = true;
            } else if (name.equals("tEXt")) {
                Node tEXt_node = node.getFirstChild();
                while (tEXt_node != null) {
                    if (!tEXt_node.getNodeName().equals("tEXtEntry")) {
                        this.fatal(node, "Only an tEXtEntry may be a child of an tEXt!");
                    }
                    String keyword = this.getAttribute(tEXt_node, "keyword");
                    this.tEXt_keyword.add(keyword);
                    String text = this.getAttribute(tEXt_node, "value");
                    this.tEXt_text.add(text);
                    tEXt_node = tEXt_node.getNextSibling();
                }
            } else if (name.equals("tIME")) {
                this.tIME_year = this.getIntAttribute(node, "year");
                this.tIME_month = this.getIntAttribute(node, "month");
                this.tIME_day = this.getIntAttribute(node, "day");
                this.tIME_hour = this.getIntAttribute(node, "hour");
                this.tIME_minute = this.getIntAttribute(node, "minute");
                this.tIME_second = this.getIntAttribute(node, "second");
                this.tIME_present = true;
            } else if (name.equals("tRNS")) {
                String tRNS_name;
                this.tRNS_present = false;
                Node tRNS_node = node.getFirstChild();
                if (tRNS_node == null) {
                    this.fatal(node, "tRNS node has no children!");
                }
                if ((tRNS_name = tRNS_node.getNodeName()).equals("tRNS_Palette")) {
                    byte[] alpha = new byte[256];
                    int maxindex = -1;
                    Node tRNS_paletteEntry = tRNS_node.getFirstChild();
                    if (tRNS_paletteEntry == null) {
                        this.fatal(node, "tRNS_Palette node has no children!");
                    }
                    while (tRNS_paletteEntry != null) {
                        int index;
                        if (!tRNS_paletteEntry.getNodeName().equals("tRNS_PaletteEntry")) {
                            this.fatal(node, "Only a tRNS_PaletteEntry may be a child of a tRNS_Palette!");
                        }
                        if ((index = this.getIntAttribute(tRNS_paletteEntry, "index")) < 0 || index > 255) {
                            this.fatal(node, "Bad value for tRNS_PaletteEntry attribute index!");
                        }
                        if (index > maxindex) {
                            maxindex = index;
                        }
                        alpha[index] = (byte)this.getIntAttribute(tRNS_paletteEntry, "alpha");
                        tRNS_paletteEntry = tRNS_paletteEntry.getNextSibling();
                    }
                    int numEntries = maxindex + 1;
                    this.tRNS_alpha = new byte[numEntries];
                    this.tRNS_colorType = 3;
                    System.arraycopy(alpha, 0, this.tRNS_alpha, 0, numEntries);
                } else if (tRNS_name.equals("tRNS_Grayscale")) {
                    this.tRNS_gray = this.getIntAttribute(tRNS_node, "gray");
                    this.tRNS_colorType = 0;
                } else if (tRNS_name.equals("tRNS_RGB")) {
                    this.tRNS_red = this.getIntAttribute(tRNS_node, "red");
                    this.tRNS_green = this.getIntAttribute(tRNS_node, "green");
                    this.tRNS_blue = this.getIntAttribute(tRNS_node, "blue");
                    this.tRNS_colorType = 2;
                } else {
                    this.fatal(node, "Bad child of a tRNS node!");
                }
                if (tRNS_node.getNextSibling() != null) {
                    this.fatal(node, "tRNS node has more than one child!");
                }
                this.tRNS_present = true;
            } else if (name.equals("zTXt")) {
                Node zTXt_node = node.getFirstChild();
                while (zTXt_node != null) {
                    if (!zTXt_node.getNodeName().equals("zTXtEntry")) {
                        this.fatal(node, "Only an zTXtEntry may be a child of an zTXt!");
                    }
                    String keyword = this.getAttribute(zTXt_node, "keyword");
                    this.zTXt_keyword.add(keyword);
                    int compressionMethod = this.getEnumeratedAttribute(zTXt_node, "compressionMethod", zTXt_compressionMethodNames);
                    this.zTXt_compressionMethod.add(new Integer(compressionMethod));
                    String text = this.getAttribute(zTXt_node, "text");
                    this.zTXt_text.add(text);
                    zTXt_node = zTXt_node.getNextSibling();
                }
            } else if (name.equals("UnknownChunks")) {
                Node unknown_node = node.getFirstChild();
                while (unknown_node != null) {
                    if (!unknown_node.getNodeName().equals("UnknownChunk")) {
                        this.fatal(node, "Only an UnknownChunk may be a child of an UnknownChunks!");
                    }
                    String chunkType = this.getAttribute(unknown_node, "type");
                    Object chunkData = ((IIOMetadataNode)unknown_node).getUserObject();
                    if (chunkType.length() != 4) {
                        this.fatal(unknown_node, "Chunk type must be 4 characters!");
                    }
                    if (chunkData == null) {
                        this.fatal(unknown_node, "No chunk data present in user object!");
                    }
                    if (!(chunkData instanceof byte[])) {
                        this.fatal(unknown_node, "User object not a byte array!");
                    }
                    this.unknownChunkType.add(chunkType);
                    this.unknownChunkData.add(((byte[])chunkData).clone());
                    unknown_node = unknown_node.getNextSibling();
                }
            } else {
                this.fatal(node, "Unknown child of root node!");
            }
            node = node.getNextSibling();
        }
    }

    private boolean isISOLatin(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) > '\u00ff') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node, "Root must be javax_imageio_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("Gamma")) {
                        float gamma = this.getFloatAttribute(child, "value");
                        this.gAMA_present = true;
                        this.gAMA_gamma = (int)((double)(gamma * 100000.0f) + 0.5);
                    } else if (childName.equals("Palette")) {
                        byte[] red = new byte[256];
                        byte[] green = new byte[256];
                        byte[] blue = new byte[256];
                        int maxindex = -1;
                        Node entry = child.getFirstChild();
                        while (entry != null) {
                            int index;
                            String entryName = entry.getNodeName();
                            if (entryName.equals("PaletteEntry") && (index = this.getIntAttribute(entry, "index")) >= 0 && index <= 255) {
                                red[index] = (byte)this.getIntAttribute(entry, "red");
                                green[index] = (byte)this.getIntAttribute(entry, "green");
                                blue[index] = (byte)this.getIntAttribute(entry, "blue");
                                if (index > maxindex) {
                                    maxindex = index;
                                }
                            }
                            entry = entry.getNextSibling();
                        }
                        int numEntries = maxindex + 1;
                        this.PLTE_red = new byte[numEntries];
                        this.PLTE_green = new byte[numEntries];
                        this.PLTE_blue = new byte[numEntries];
                        System.arraycopy(red, 0, this.PLTE_red, 0, numEntries);
                        System.arraycopy(green, 0, this.PLTE_green, 0, numEntries);
                        System.arraycopy(blue, 0, this.PLTE_blue, 0, numEntries);
                        this.PLTE_present = true;
                    } else if (childName.equals("BackgroundIndex")) {
                        this.bKGD_present = true;
                        this.bKGD_colorType = 3;
                        this.bKGD_index = this.getIntAttribute(child, "value");
                    } else if (childName.equals("BackgroundColor")) {
                        int red = this.getIntAttribute(child, "red");
                        int green = this.getIntAttribute(child, "green");
                        int blue = this.getIntAttribute(child, "blue");
                        if (red == green && red == blue) {
                            this.bKGD_colorType = 0;
                            this.bKGD_gray = red;
                        } else {
                            this.bKGD_colorType = 2;
                            this.bKGD_red = red;
                            this.bKGD_green = green;
                            this.bKGD_blue = blue;
                        }
                        this.bKGD_present = true;
                    }
                    child = child.getNextSibling();
                }
            } else if (name.equals("Compression")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("NumProgressiveScans")) {
                        int scans = this.getIntAttribute(child, "value");
                        this.IHDR_interlaceMethod = scans > 1 ? 1 : 0;
                    }
                    child = child.getNextSibling();
                }
            } else if (name.equals("Data")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    StringTokenizer t;
                    String s;
                    String childName = child.getNodeName();
                    if (childName.equals("BitsPerSample")) {
                        s = this.getAttribute(child, "value");
                        t = new StringTokenizer(s);
                        int maxBits = -1;
                        while (t.hasMoreTokens()) {
                            int bits = Integer.parseInt(t.nextToken());
                            if (bits <= maxBits) continue;
                            maxBits = bits;
                        }
                        if (maxBits < 1) {
                            maxBits = 1;
                        } else if (maxBits == 3) {
                            maxBits = 4;
                        } else if (maxBits > 4 && maxBits < 8) {
                            maxBits = 8;
                        } else if (maxBits > 8) {
                            maxBits = 16;
                        }
                        this.IHDR_bitDepth = maxBits;
                    } else if (childName.equals("SignificantBitsPerSample")) {
                        s = this.getAttribute(child, "value");
                        t = new StringTokenizer(s);
                        int numTokens = t.countTokens();
                        if (numTokens == 1) {
                            this.sBIT_colorType = 0;
                            this.sBIT_grayBits = Integer.parseInt(t.nextToken());
                        } else if (numTokens == 2) {
                            this.sBIT_colorType = 4;
                            this.sBIT_grayBits = Integer.parseInt(t.nextToken());
                            this.sBIT_alphaBits = Integer.parseInt(t.nextToken());
                        } else if (numTokens == 3) {
                            this.sBIT_colorType = 2;
                            this.sBIT_redBits = Integer.parseInt(t.nextToken());
                            this.sBIT_greenBits = Integer.parseInt(t.nextToken());
                            this.sBIT_blueBits = Integer.parseInt(t.nextToken());
                        } else if (numTokens == 4) {
                            this.sBIT_colorType = 6;
                            this.sBIT_redBits = Integer.parseInt(t.nextToken());
                            this.sBIT_greenBits = Integer.parseInt(t.nextToken());
                            this.sBIT_blueBits = Integer.parseInt(t.nextToken());
                            this.sBIT_alphaBits = Integer.parseInt(t.nextToken());
                        }
                        if (numTokens >= 1 && numTokens <= 4) {
                            this.sBIT_present = true;
                        }
                    }
                    child = child.getNextSibling();
                }
            } else if (name.equals("Dimension")) {
                boolean gotWidth = false;
                boolean gotHeight = false;
                boolean gotAspectRatio = false;
                float width = -1.0f;
                float height = -1.0f;
                float aspectRatio = -1.0f;
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("PixelAspectRatio")) {
                        aspectRatio = this.getFloatAttribute(child, "value");
                        gotAspectRatio = true;
                    } else if (childName.equals("HorizontalPixelSize")) {
                        width = this.getFloatAttribute(child, "value");
                        gotWidth = true;
                    } else if (childName.equals("VerticalPixelSize")) {
                        height = this.getFloatAttribute(child, "value");
                        gotHeight = true;
                    }
                    child = child.getNextSibling();
                }
                if (gotWidth && gotHeight) {
                    this.pHYs_present = true;
                    this.pHYs_unitSpecifier = 1;
                    this.pHYs_pixelsPerUnitXAxis = (int)(1000.0f / width + 0.5f);
                    this.pHYs_pixelsPerUnitYAxis = (int)(1000.0f / height + 0.5f);
                } else if (gotAspectRatio) {
                    this.pHYs_present = true;
                    this.pHYs_unitSpecifier = 0;
                    int denom = 1;
                    while (denom < 100) {
                        int num = (int)(aspectRatio * (float)denom);
                        if ((double)Math.abs((float)(num / denom) - aspectRatio) < 0.001) break;
                        ++denom;
                    }
                    this.pHYs_pixelsPerUnitXAxis = (int)(aspectRatio * (float)denom);
                    this.pHYs_pixelsPerUnitYAxis = denom;
                }
            } else if (name.equals("Document")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("ImageModificationTime")) {
                        this.tIME_present = true;
                        this.tIME_year = this.getIntAttribute(child, "year");
                        this.tIME_month = this.getIntAttribute(child, "month");
                        this.tIME_day = this.getIntAttribute(child, "day");
                        this.tIME_hour = this.getIntAttribute(child, "hour", 0, false);
                        this.tIME_minute = this.getIntAttribute(child, "minute", 0, false);
                        this.tIME_second = this.getIntAttribute(child, "second", 0, false);
                    }
                    child = child.getNextSibling();
                }
            } else if (name.equals("Text")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    String childName = child.getNodeName();
                    if (childName.equals("TextEntry")) {
                        String keyword = this.getAttribute(child, "keyword", "text", false);
                        String value = this.getAttribute(child, "value");
                        String encoding = this.getAttribute(child, "encoding", "unknown", false);
                        String language = this.getAttribute(child, "language", "unknown", false);
                        String compression = this.getAttribute(child, "compression", "other", false);
                        if (this.isISOLatin(value)) {
                            if (compression.equals("zip")) {
                                this.zTXt_keyword.add(keyword);
                                this.zTXt_text.add(value);
                                this.zTXt_compressionMethod.add(new Integer(0));
                            } else {
                                this.tEXt_keyword.add(keyword);
                                this.tEXt_text.add(value);
                            }
                        } else {
                            int flag = compression.equals("zip") ? 1 : 0;
                            this.iTXt_keyword.add(keyword);
                            this.iTXt_compressionFlag.add(new Integer(flag));
                            this.iTXt_compressionMethod.add(new Integer(0));
                            this.iTXt_languageTag.add(language);
                            this.iTXt_translatedKeyword.add(keyword);
                            this.iTXt_text.add(value);
                        }
                    }
                    child = child.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    public void reset() {
        this.IHDR_present = false;
        this.PLTE_present = false;
        this.bKGD_present = false;
        this.cHRM_present = false;
        this.gAMA_present = false;
        this.hIST_present = false;
        this.iCCP_present = false;
        this.iTXt_keyword = new ArrayList();
        this.iTXt_compressionFlag = new ArrayList();
        this.iTXt_compressionMethod = new ArrayList();
        this.iTXt_languageTag = new ArrayList();
        this.iTXt_translatedKeyword = new ArrayList();
        this.iTXt_text = new ArrayList();
        this.pHYs_present = false;
        this.sBIT_present = false;
        this.sPLT_present = false;
        this.sRGB_present = false;
        this.tEXt_keyword = new ArrayList();
        this.tEXt_text = new ArrayList();
        this.tIME_present = false;
        this.tRNS_present = false;
        this.zTXt_keyword = new ArrayList();
        this.zTXt_compressionMethod = new ArrayList();
        this.zTXt_text = new ArrayList();
        this.unknownChunkType = new ArrayList();
        this.unknownChunkData = new ArrayList();
    }

    private static int chunkType(String typeString) {
        char c0 = typeString.charAt(0);
        char c1 = typeString.charAt(1);
        char c2 = typeString.charAt(2);
        char c3 = typeString.charAt(3);
        int type = c0 << 24 | c1 << 16 | c2 << 8 | c3;
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private String readNullTerminatedString(ImageInputStream stream) throws IOException {
        int c;
        StringBuffer b = new StringBuffer();
        while ((c = stream.read()) != 0) {
            void var3_3;
            b.append((char)var3_3);
        }
        return b.toString();
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        try {
            int colorType;
            mediaLibImage mlibImage = this.decoder.getImage();
            int width = mlibImage.getWidth();
            int height = mlibImage.getHeight();
            int bitDepth = this.decoder.getBitDepth();
            switch (mlibImage.getChannels()) {
                case 1: {
                    colorType = this.decoder.getPalette() == null ? 0 : 3;
                    break;
                }
                case 2: {
                    colorType = 4;
                    break;
                }
                case 3: {
                    colorType = 2;
                    break;
                }
                case 4: {
                    colorType = 6;
                    break;
                }
                default: {
                    throw new IIOException("Unsupported image type.");
                }
            }
            int compressionMethod = 0;
            int filterMethod = 0;
            int interlaceMethod = this.decoder.getInterlaceMethod();
            if (width == 0) {
                throw new IIOException("Image width == 0!");
            }
            if (height == 0) {
                throw new IIOException("Image height == 0!");
            }
            if (bitDepth != 1 && bitDepth != 2 && bitDepth != 4 && bitDepth != 8 && bitDepth != 16) {
                throw new IIOException("Bit depth must be 1, 2, 4, 8, or 16!");
            }
            if (colorType != 0 && colorType != 2 && colorType != 3 && colorType != 4 && colorType != 6) {
                throw new IIOException("Color type must be 0, 2, 3, 4, or 6!");
            }
            if (colorType == 3 && bitDepth == 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if ((colorType == 2 || colorType == 6 || colorType == 4) && bitDepth != 8 && bitDepth != 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if (compressionMethod != 0) {
                throw new IIOException("Unknown compression method (not 0)!");
            }
            if (filterMethod != 0) {
                throw new IIOException("Unknown filter method (not 0)!");
            }
            if (interlaceMethod != 0 && interlaceMethod != 1) {
                throw new IIOException("Unknown interlace method (not 0 or 1)!");
            }
            this.IHDR_present = true;
            this.IHDR_width = width;
            this.IHDR_height = height;
            this.IHDR_bitDepth = bitDepth;
            this.IHDR_colorType = colorType;
            this.IHDR_compressionMethod = compressionMethod;
            this.IHDR_filterMethod = filterMethod;
            this.IHDR_interlaceMethod = interlaceMethod;
            this.gotHeader = true;
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading PNG header!", e);
        }
    }

    private void parse_PLTE_chunk() throws IOException {
        if (this.PLTE_present) {
            this.processWarningOccurred("A PNG image may not contain more than one PLTE chunk.\nThe chunk will be ignored.");
            return;
        }
        if (this.IHDR_colorType == 0 || this.IHDR_colorType == 4) {
            this.processWarningOccurred("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk will be ignored.");
            return;
        }
        byte[] palette = this.decoder.getPalette();
        if (palette != null) {
            int maxEntries;
            int numEntries = palette.length / 3;
            if (this.IHDR_colorType == 3 && numEntries > (maxEntries = 1 << this.IHDR_bitDepth)) {
                this.processWarningOccurred("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                numEntries = maxEntries;
            }
            int paletteEntries = numEntries > 16 ? 256 : (numEntries > 4 ? 16 : (numEntries > 2 ? 4 : 2));
            this.PLTE_present = true;
            this.PLTE_red = new byte[paletteEntries];
            this.PLTE_green = new byte[paletteEntries];
            this.PLTE_blue = new byte[paletteEntries];
            int index = 0;
            int i = 0;
            while (i < numEntries) {
                this.PLTE_red[i] = palette[index++];
                this.PLTE_green[i] = palette[index++];
                this.PLTE_blue[i] = palette[index++];
                ++i;
            }
        }
    }

    private void parse_bKGD_chunk() throws IOException {
        int[] background = this.decoder.getBackground();
        if (background != null) {
            if (this.IHDR_colorType == 3) {
                this.bKGD_colorType = 3;
                this.bKGD_index = background[0];
            } else if (this.IHDR_colorType == 0 || this.IHDR_colorType == 4) {
                this.bKGD_colorType = 0;
                this.bKGD_gray = background[0];
            } else {
                this.bKGD_colorType = 2;
                this.bKGD_red = background[0];
                this.bKGD_green = background[1];
                this.bKGD_blue = background[2];
            }
            this.bKGD_present = true;
        }
    }

    private void parse_cHRM_chunk() throws IOException {
        int[] chrm = this.decoder.getAllPrimaryChromaticities();
        if (chrm != null) {
            int i = 0;
            this.cHRM_whitePointX = chrm[i++];
            this.cHRM_whitePointY = chrm[i++];
            this.cHRM_redX = chrm[i++];
            this.cHRM_redY = chrm[i++];
            this.cHRM_greenX = chrm[i++];
            this.cHRM_greenY = chrm[i++];
            this.cHRM_blueX = chrm[i++];
            this.cHRM_blueY = chrm[i++];
            this.cHRM_present = true;
        }
    }

    private void parse_gAMA_chunk() throws IOException {
        int gamma = this.decoder.getImageGamma();
        if (gamma != -1) {
            this.gAMA_gamma = gamma;
            this.gAMA_present = true;
        }
    }

    private void parse_hIST_chunk() throws IOException, IIOException {
        short[] histogram = this.decoder.getHistogram();
        if (histogram != null) {
            if (!this.PLTE_present) {
                throw new IIOException("hIST chunk without prior PLTE chunk!");
            }
            int length = Math.min(this.PLTE_red.length, histogram.length);
            this.hIST_histogram = new char[length];
            int i = 0;
            while (i < length) {
                this.hIST_histogram[i] = (char)histogram[i];
                ++i;
            }
            this.hIST_present = true;
        }
    }

    private void parse_iCCP_chunk() throws IOException {
        String profileName = this.decoder.getEmbeddedICCProfileName();
        if (profileName != null) {
            this.iCCP_profileName = profileName;
            byte[] uncompressedProfile = this.decoder.getEmbeddedICCProfile();
            Deflater compressor = new Deflater(9);
            compressor.setInput(uncompressedProfile);
            compressor.finish();
            int off = 0;
            int len = uncompressedProfile.length;
            byte[] compressedProfile = new byte[uncompressedProfile.length];
            do {
                int count = compressor.deflate(compressedProfile, off, len);
                off += count;
                len -= count;
            } while (!compressor.finished());
            int compressedDataLength = off;
            this.iCCP_compressedProfile = new byte[compressedDataLength];
            System.arraycopy(compressedProfile, 0, this.iCCP_compressedProfile, 0, compressedDataLength);
            this.iCCP_present = true;
        }
    }

    private void parse_pHYs_chunk() throws IOException {
        int unitSpecifier = this.decoder.getPhysicalPixelDimensions(2);
        if (unitSpecifier != -1) {
            this.pHYs_pixelsPerUnitXAxis = this.decoder.getPhysicalPixelDimensions(0);
            this.pHYs_pixelsPerUnitYAxis = this.decoder.getPhysicalPixelDimensions(1);
            this.pHYs_unitSpecifier = unitSpecifier;
            this.pHYs_present = true;
        }
    }

    private void parse_sBIT_chunk() throws IOException {
        byte[] sBits = this.decoder.getSignificantBits();
        if (sBits != null) {
            int i = 0;
            int colorType = this.IHDR_colorType;
            if (colorType == 0 || colorType == 4) {
                this.sBIT_grayBits = sBits[i++];
            } else if (colorType == 2 || colorType == 3 || colorType == 6) {
                this.sBIT_redBits = sBits[i++];
                this.sBIT_greenBits = sBits[i++];
                this.sBIT_blueBits = sBits[i++];
            }
            if (colorType == 4 || colorType == 6) {
                this.sBIT_alphaBits = sBits[i++];
            }
            this.sBIT_colorType = colorType;
            this.sBIT_present = true;
        }
    }

    private void parse_sPLT_chunk() throws IOException, IIOException {
        PNGChunk[] sPLTChunks = this.decoder.getSuggestedPalette();
        if (sPLTChunks != null && sPLTChunks.length > 0 && sPLTChunks[0] != null) {
            int sampleDepth;
            PNGChunk sPLTChunk = sPLTChunks[0];
            byte[] chunkData = sPLTChunk.getData();
            int chunkLength = chunkData.length;
            ByteArrayInputStream is = new ByteArrayInputStream(sPLTChunk.getData());
            MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(is);
            this.sPLT_paletteName = this.readNullTerminatedString(stream);
            this.sPLT_sampleDepth = sampleDepth = stream.readUnsignedByte();
            int numEntries = (chunkLength -= this.sPLT_paletteName.length() + 1) / (4 * (sampleDepth / 8) + 2);
            this.sPLT_red = new int[numEntries];
            this.sPLT_green = new int[numEntries];
            this.sPLT_blue = new int[numEntries];
            this.sPLT_alpha = new int[numEntries];
            this.sPLT_frequency = new int[numEntries];
            if (sampleDepth == 8) {
                int i = 0;
                while (i < numEntries) {
                    this.sPLT_red[i] = stream.readUnsignedByte();
                    this.sPLT_green[i] = stream.readUnsignedByte();
                    this.sPLT_blue[i] = stream.readUnsignedByte();
                    this.sPLT_alpha[i] = stream.readUnsignedByte();
                    this.sPLT_frequency[i] = stream.readUnsignedShort();
                    ++i;
                }
            } else if (sampleDepth == 16) {
                int i = 0;
                while (i < numEntries) {
                    this.sPLT_red[i] = stream.readUnsignedShort();
                    this.sPLT_green[i] = stream.readUnsignedShort();
                    this.sPLT_blue[i] = stream.readUnsignedShort();
                    this.sPLT_alpha[i] = stream.readUnsignedShort();
                    this.sPLT_frequency[i] = stream.readUnsignedShort();
                    ++i;
                }
            } else {
                throw new IIOException("sPLT sample depth not 8 or 16!");
            }
            this.sPLT_present = true;
        }
    }

    private void parse_sRGB_chunk() throws IOException {
        int renderingIntent = this.decoder.getStandardRGB();
        if (renderingIntent != -1) {
            this.sRGB_renderingIntent = renderingIntent;
            this.sRGB_present = true;
        }
    }

    private void parse_tIME_chunk() throws IOException {
        Calendar cal = this.decoder.getLastModificationTime();
        if (cal != null) {
            this.tIME_year = cal.get(1);
            this.tIME_month = cal.get(2) + 1;
            this.tIME_day = cal.get(5);
            this.tIME_hour = cal.get(11);
            this.tIME_minute = cal.get(12);
            this.tIME_second = cal.get(13);
            this.tIME_present = true;
        }
    }

    private void parse_tRNS_chunk() throws IOException {
        int[] transparency = this.decoder.getTransparency();
        if (transparency == null) {
            return;
        }
        int colorType = this.IHDR_colorType;
        if (colorType == 3) {
            if (!this.PLTE_present) {
                this.processWarningOccurred("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int numEntries = transparency.length;
            int maxEntries = this.PLTE_red.length;
            if (numEntries > maxEntries) {
                this.processWarningOccurred("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                numEntries = maxEntries;
            }
            this.tRNS_alpha = new byte[numEntries];
            this.tRNS_colorType = 3;
            int i = 0;
            while (i < numEntries) {
                this.tRNS_alpha[i] = (byte)transparency[i];
                ++i;
            }
        } else if (colorType == 0) {
            if (transparency.length != 1) {
                this.processWarningOccurred("tRNS chunk for gray image must have length 2, ignoring chunk.");
                return;
            }
            this.tRNS_gray = transparency[0];
            this.tRNS_colorType = 0;
        } else if (colorType == 2) {
            if (transparency.length != 3) {
                this.processWarningOccurred("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                return;
            }
            this.tRNS_red = transparency[0];
            this.tRNS_green = transparency[1];
            this.tRNS_blue = transparency[2];
            this.tRNS_colorType = 2;
        } else {
            this.processWarningOccurred("Gray+Alpha and RGBA images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.tRNS_present = true;
    }

    private void parseTextChunk() throws IOException {
        PNGTextualData[] textualData = this.decoder.getTextualData();
        if (textualData != null) {
            int i = 0;
            while (i < textualData.length) {
                PNGTextualData textData = textualData[i];
                String keyword = textData.getKeyword();
                String text = textData.getText();
                String translatedKeyword = textData.getTranslatedKeyword();
                if (keyword.equals(translatedKeyword)) {
                    this.tEXt_keyword.add(keyword);
                    this.tEXt_text.add(text);
                } else {
                    this.iTXt_keyword.add(keyword);
                    this.iTXt_text.add(text);
                    this.iTXt_translatedKeyword.add(translatedKeyword);
                    int compressionFlag = 0;
                    this.iTXt_compressionFlag.add(new Integer(compressionFlag));
                    int compressionMethod = 0;
                    this.iTXt_compressionMethod.add(new Integer(compressionMethod));
                    String languageTag = textData.getEncoding();
                    this.iTXt_languageTag.add(languageTag);
                }
                ++i;
            }
        }
    }

    synchronized void readMetadata(CLibPNGImageReader reader, Decoder decoder) throws IIOException {
        if (this.gotMetadata) {
            return;
        }
        this.reader = reader;
        this.decoder = decoder;
        this.readHeader();
        try {
            block7: {
                try {
                    this.parse_PLTE_chunk();
                    this.parse_bKGD_chunk();
                    this.parse_cHRM_chunk();
                    this.parse_gAMA_chunk();
                    this.parse_hIST_chunk();
                    this.parse_iCCP_chunk();
                    this.parse_pHYs_chunk();
                    this.parse_sBIT_chunk();
                    this.parse_sPLT_chunk();
                    this.parse_sRGB_chunk();
                    this.parse_tIME_chunk();
                    this.parse_tRNS_chunk();
                    this.parseTextChunk();
                    PNGChunk[] userChunks = decoder.getUserData();
                    if (userChunks == null) break block7;
                    int i = 0;
                    while (i < userChunks.length) {
                        PNGChunk userChunk = userChunks[i];
                        int chunkType = userChunk.getID();
                        byte[] b = userChunk.getData();
                        StringBuffer chunkName = new StringBuffer(4);
                        chunkName.append((char)(chunkType >>> 24));
                        chunkName.append((char)(chunkType >> 16 & 0xFF));
                        chunkName.append((char)(chunkType >> 8 & 0xFF));
                        chunkName.append((char)(chunkType & 0xFF));
                        int ancillaryBit = chunkType >>> 28;
                        if (ancillaryBit == 0) {
                            this.processWarningOccurred("Encountered unknown chunk with critical bit set!");
                        }
                        this.unknownChunkType.add(chunkName.toString());
                        this.unknownChunkData.add(b);
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IIOException("Error reading PNG metadata", e);
                }
            }
            Object var11_11 = null;
            this.reader = null;
            this.decoder = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.reader = null;
            this.decoder = null;
            throw throwable;
        }
        this.gotMetadata = true;
    }

    void processWarningOccurred(String warning) {
        if (this.reader != null) {
            this.reader.forwardWarningMessage(warning);
        }
    }

    synchronized void writeMetadata(Encoder encoder) throws IIOException {
        int i;
        if (this.IHDR_present) {
            encoder.setBitDepth(this.IHDR_bitDepth);
            encoder.setInterlaceMethod(this.IHDR_interlaceMethod == 0 ? 0 : 1);
        }
        if (this.PLTE_present) {
            int paletteLength = this.PLTE_red.length;
            byte[] palette = new byte[3 * paletteLength];
            i = 0;
            int j = 0;
            while (i < paletteLength) {
                palette[j++] = this.PLTE_red[i];
                palette[j++] = this.PLTE_green[i];
                palette[j++] = this.PLTE_blue[i];
                ++i;
            }
            encoder.setPalette(palette);
        }
        if (this.bKGD_present) {
            int[] color;
            switch (this.bKGD_colorType) {
                case 0: {
                    color = new int[]{this.bKGD_gray};
                    break;
                }
                case 3: {
                    color = new int[]{this.bKGD_index};
                    break;
                }
                default: {
                    color = new int[]{this.bKGD_red, this.bKGD_green, this.bKGD_blue};
                }
            }
            encoder.setBackground(color);
        }
        if (this.cHRM_present) {
            encoder.setPrimaryChromaticities(this.cHRM_whitePointX, this.cHRM_whitePointY, this.cHRM_redX, this.cHRM_redY, this.cHRM_greenX, this.cHRM_greenY, this.cHRM_blueX, this.cHRM_blueY);
        }
        if (this.gAMA_present) {
            encoder.setImageGamma(this.gAMA_gamma);
        }
        if (this.hIST_present) {
            int histogramLength = this.hIST_histogram.length;
            short[] histogram = new short[histogramLength];
            i = 0;
            while (i < histogramLength) {
                histogram[i] = (short)this.hIST_histogram[i];
                ++i;
            }
            encoder.setHistogram(histogram);
        }
        if (this.iCCP_present) {
            encoder.setEmbeddedICCProfile(this.iCCP_profileName, this.iCCP_compressedProfile);
        }
        if (this.iTXt_keyword.size() > 0) {
            int numChunks = this.iTXt_keyword.size();
            int i2 = 0;
            while (i2 < numChunks) {
                Integer compressionFlag = Integer.valueOf((String)this.iTXt_compressionFlag.get(i2));
                encoder.setUnicodeTextualData((String)this.iTXt_keyword.get(i2), (String)this.iTXt_translatedKeyword.get(i2), (String)this.iTXt_languageTag.get(i2), (String)this.iTXt_text.get(i2), compressionFlag == 1);
                ++i2;
            }
        }
        if (this.pHYs_present) {
            encoder.setPhysicalPixelDimensions(this.pHYs_pixelsPerUnitXAxis, this.pHYs_pixelsPerUnitYAxis, this.pHYs_unitSpecifier);
        }
        if (this.sBIT_present) {
            byte[] bits;
            switch (this.sBIT_colorType) {
                case 0: {
                    bits = new byte[]{(byte)(this.sBIT_grayBits & 0xFF)};
                    break;
                }
                case 4: {
                    bits = new byte[]{(byte)(this.sBIT_grayBits & 0xFF), (byte)(this.sBIT_alphaBits & 0xFF)};
                    break;
                }
                case 6: {
                    bits = new byte[]{(byte)(this.sBIT_redBits & 0xFF), (byte)(this.sBIT_greenBits & 0xFF), (byte)(this.sBIT_blueBits & 0xFF), (byte)(this.sBIT_alphaBits & 0xFF)};
                    break;
                }
                default: {
                    bits = new byte[]{(byte)(this.sBIT_redBits & 0xFF), (byte)(this.sBIT_greenBits & 0xFF), (byte)(this.sBIT_blueBits & 0xFF)};
                }
            }
            encoder.setSignificantBits(bits);
        }
        if (this.sPLT_present) {
            int i3;
            int length;
            short[] frequency;
            if (this.sPLT_sampleDepth == 8) {
                byte[] red = new byte[this.sPLT_red.length];
                byte[] green = new byte[this.sPLT_green.length];
                byte[] blue = new byte[this.sPLT_blue.length];
                byte[] alpha = new byte[this.sPLT_alpha.length];
                frequency = new short[this.sPLT_frequency.length];
                length = red.length;
                i3 = 0;
                while (i3 < length) {
                    red[i3] = (byte)(this.sPLT_red[i3] & 0xFF);
                    green[i3] = (byte)(this.sPLT_green[i3] & 0xFF);
                    blue[i3] = (byte)(this.sPLT_blue[i3] & 0xFF);
                    alpha[i3] = (byte)(this.sPLT_alpha[i3] & 0xFF);
                    frequency[i3] = (short)(this.sPLT_frequency[i3] & 0xFFFF);
                    ++i3;
                }
                encoder.setSuggestedPalette(this.sPLT_paletteName, red, green, blue, alpha, frequency);
            } else {
                short[] red = new short[this.sPLT_red.length];
                short[] green = new short[this.sPLT_green.length];
                short[] blue = new short[this.sPLT_blue.length];
                short[] alpha = new short[this.sPLT_alpha.length];
                frequency = new short[this.sPLT_frequency.length];
                length = red.length;
                i3 = 0;
                while (i3 < length) {
                    red[i3] = (short)(this.sPLT_red[i3] & 0xFFFF);
                    green[i3] = (short)(this.sPLT_green[i3] & 0xFFFF);
                    blue[i3] = (short)(this.sPLT_blue[i3] & 0xFFFF);
                    alpha[i3] = (short)(this.sPLT_alpha[i3] & 0xFFFF);
                    frequency[i3] = (short)(this.sPLT_frequency[i3] & 0xFFFF);
                    ++i3;
                }
                encoder.setSuggestedPalette(this.sPLT_paletteName, red, green, blue, alpha, frequency);
            }
        }
        if (this.sRGB_present) {
            encoder.setStandardRGB(this.sRGB_renderingIntent);
        }
        if (this.tEXt_keyword.size() > 0) {
            int numChunks = this.tEXt_keyword.size();
            int i4 = 0;
            while (i4 < numChunks) {
                encoder.setTextualData((String)this.tEXt_keyword.get(i4), (String)this.tEXt_text.get(i4), false);
                ++i4;
            }
        }
        if (this.tIME_present) {
            encoder.setLastModificationTime(new GregorianCalendar(this.tIME_year, this.tIME_month - 1, this.tIME_day, this.tIME_hour, this.tIME_minute, this.tIME_second));
        }
        if (this.tRNS_present) {
            if (this.tRNS_colorType == 0) {
                encoder.setTransparency(this.tRNS_gray, this.tRNS_gray, this.tRNS_gray);
            } else if (this.tRNS_colorType == 3) {
                int length = this.tRNS_alpha.length;
                int[] color = new int[length];
                int i5 = 0;
                while (i5 < length) {
                    color[i5] = this.tRNS_alpha[i5] & 0xFF;
                    ++i5;
                }
                encoder.setTransparency(color);
            } else {
                encoder.setTransparency(this.tRNS_red, this.tRNS_green, this.tRNS_blue);
            }
        }
        if (this.zTXt_keyword.size() > 0) {
            int numChunks = this.zTXt_keyword.size();
            int i6 = 0;
            while (i6 < numChunks) {
                encoder.setTextualData((String)this.zTXt_keyword.get(i6), (String)this.zTXt_text.get(i6), true);
                ++i6;
            }
        }
        if (this.unknownChunkType.size() > 0) {
            int numChunks = this.unknownChunkType.size();
            int i7 = 0;
            while (i7 < numChunks) {
                encoder.setUserData((String)this.unknownChunkType.get(i7), (byte[])this.unknownChunkData.get(i7), 0);
                ++i7;
            }
        }
    }

    static {
        nativeMetadataFormatName = nativeMetadataFormatName;
        nativeMetadataFormatClassName = nativeMetadataFormatClassName;
        IHDR_colorTypeNames = new String[]{"Grayscale", null, "RGB", "Palette", "GrayAlpha", null, "RGBAlpha"};
        IHDR_numChannels = new int[]{1, 0, 3, 3, 2, 0, 4};
        IHDR_bitDepths = new String[]{"1", "2", "4", "8", "16"};
        IHDR_compressionMethodNames = new String[]{"deflate"};
        IHDR_filterMethodNames = new String[]{"adaptive"};
        IHDR_interlaceMethodNames = new String[]{"none", "adam7"};
        iCCP_compressionMethodNames = new String[]{"deflate"};
        zTXt_compressionMethodNames = new String[]{"deflate"};
        PHYS_UNIT_UNKNOWN = 0;
        PHYS_UNIT_METER = 1;
        unitSpecifierNames = new String[]{"unknown", "meter"};
        renderingIntentNames = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};
        colorSpaceTypeNames = new String[]{"GRAY", null, "RGB", "RGB", "GRAY", null, "RGB"};
        IHDR_TYPE = CLibPNGMetadata.chunkType("IHDR");
        PLTE_TYPE = CLibPNGMetadata.chunkType("PLTE");
        IDAT_TYPE = CLibPNGMetadata.chunkType("IDAT");
        IEND_TYPE = CLibPNGMetadata.chunkType("IEND");
        bKGD_TYPE = CLibPNGMetadata.chunkType("bKGD");
        cHRM_TYPE = CLibPNGMetadata.chunkType("cHRM");
        gAMA_TYPE = CLibPNGMetadata.chunkType("gAMA");
        hIST_TYPE = CLibPNGMetadata.chunkType("hIST");
        iCCP_TYPE = CLibPNGMetadata.chunkType("iCCP");
        iTXt_TYPE = CLibPNGMetadata.chunkType("iTXt");
        pHYs_TYPE = CLibPNGMetadata.chunkType("pHYs");
        sBIT_TYPE = CLibPNGMetadata.chunkType("sBIT");
        sPLT_TYPE = CLibPNGMetadata.chunkType("sPLT");
        sRGB_TYPE = CLibPNGMetadata.chunkType("sRGB");
        tEXt_TYPE = CLibPNGMetadata.chunkType("tEXt");
        tIME_TYPE = CLibPNGMetadata.chunkType("tIME");
        tRNS_TYPE = CLibPNGMetadata.chunkType("tRNS");
        zTXt_TYPE = CLibPNGMetadata.chunkType("zTXt");
        PNG_COLOR_GRAY = 0;
        PNG_COLOR_RGB = 2;
        PNG_COLOR_PALETTE = 3;
        PNG_COLOR_GRAY_ALPHA = 4;
        PNG_COLOR_RGB_ALPHA = 6;
    }
}

