/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibPNGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static final String[] readerSpiNames;

    public CLibPNGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            Object coreWriterSPI;
            Class<?> coreWriterSPIClass = null;
            try {
                coreWriterSPIClass = Class.forName("com.sun.imageio.plugins.png.PNGImageWriterSpi");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (coreWriterSPIClass != null && (coreWriterSPI = registry.getServiceProviderByClass(coreWriterSPIClass)) != null) {
                registry.setOrdering(category, this, coreWriterSPI);
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        boolean hasAlpha;
        SampleModel sampleModel = type.getSampleModel();
        ColorModel colorModel = type.getColorModel();
        int[] sampleSize = sampleModel.getSampleSize();
        int bitDepth = sampleSize[0];
        int i = 1;
        while (i < sampleSize.length) {
            if (sampleSize[i] != bitDepth) {
                return false;
            }
            ++i;
        }
        if (bitDepth != 1 && bitDepth != 8 && bitDepth != 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        if (numBands < 1 || numBands > 4) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        boolean bl = hasAlpha = colorModel != null && colorModel.hasAlpha();
        if ((numBands == 1 || numBands == 3) && hasAlpha) {
            return false;
        }
        return numBands != 2 && numBands != 4 || hasAlpha;
    }

    public String getDescription(Locale locale) {
        return "codecLib PNG image writer";
    }

    public ImageWriter createWriterInstance(Object extension) {
        return new CLibPNGImageWriter(this);
    }

    static {
        writerClassName = writerClassName;
        readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageReaderSpi"};
    }
}

